/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions;

import java.util.Set;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class ConferenceDescriptionPacketExtension
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://jitsi.org/protocol/condesc";
    public static final String ELEMENT_NAME = "conference";
    public static final String TRANSPORT_ELEM_NAME = "transport";
    public static final String URI_ATTR_NAME = "uri";
    public static final String PASSWORD_ATTR_NAME = "auth";
    public static final String CALLID_ATTR_NAME = "callid";
    public static final String CALLID_ELEM_NAME = "callid";
    public static final String AVAILABLE_ATTR_NAME = "available";
    public static final String CONFERENCE_NAME_ATTR_NAME = "conference_name";

    public ConferenceDescriptionPacketExtension() {
        this(null, null, null);
    }

    public ConferenceDescriptionPacketExtension(String uri) {
        this(uri, null, null);
    }

    public ConferenceDescriptionPacketExtension(String uri, String callId) {
        this(uri, callId, null);
    }

    public ConferenceDescriptionPacketExtension(String uri, String callId, String password) {
        super(NAMESPACE, ELEMENT_NAME);
        if (uri != null) {
            this.setUri(uri);
        }
        if (callId != null) {
            this.setCallId(callId);
        }
        if (password != null) {
            this.setAuth(password);
        }
    }

    public ConferenceDescriptionPacketExtension(ConferenceDescription cd) {
        this(cd.getUri(), cd.getCallId(), cd.getPassword());
        this.setAvailable(cd.isAvailable());
        if (cd.getDisplayName() != null) {
            this.setName(cd.getDisplayName());
        }
        Set transports = cd.getSupportedTransports();
        for (String transport : transports) {
            this.addChildExtension(new TransportPacketExtension(transport));
        }
    }

    public String getUri() {
        return this.getAttributeAsString(URI_ATTR_NAME);
    }

    public String getCallId() {
        return this.getAttributeAsString("callid");
    }

    public String getPassword() {
        return this.getAttributeAsString(PASSWORD_ATTR_NAME);
    }

    public void setUri(String uri) {
        this.setAttribute(URI_ATTR_NAME, StringUtils.escapeForXML((String)uri));
    }

    public void setCallId(String callId) {
        this.setAttribute("callid", callId);
    }

    public void setAuth(String password) {
        this.setAttribute(PASSWORD_ATTR_NAME, password);
    }

    public void setAvailable(boolean available) {
        this.setAttribute(AVAILABLE_ATTR_NAME, available);
    }

    public void setName(String name) {
        this.setAttribute(CONFERENCE_NAME_ATTR_NAME, StringUtils.escapeForXML((String)name));
    }

    public boolean isAvailable() {
        return Boolean.parseBoolean(this.getAttributeAsString(AVAILABLE_ATTR_NAME));
    }

    public void addTransport(String transport) {
        this.addChildExtension(new TransportPacketExtension(transport));
    }

    public ConferenceDescription toConferenceDescription() {
        ConferenceDescription conferenceDescription = new ConferenceDescription(this.getUri(), this.getCallId(), this.getPassword());
        conferenceDescription.setAvailable(this.isAvailable());
        conferenceDescription.setDisplayName(this.getName());
        for (TransportPacketExtension t : this.getChildExtensionsOfType(TransportPacketExtension.class)) {
            conferenceDescription.addTransport(t.getNamespace());
        }
        return conferenceDescription;
    }

    private String getName() {
        return this.getAttributeAsString(CONFERENCE_NAME_ATTR_NAME);
    }

    public static class Provider
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            ConferenceDescriptionPacketExtension packetExtension = new ConferenceDescriptionPacketExtension();
            int attrCount = parser.getAttributeCount();
            int i = 0;
            while (i < attrCount) {
                packetExtension.setAttribute(parser.getAttributeName(i), parser.getAttributeValue(i));
                ++i;
            }
            boolean done = false;
            TransportPacketExtension transportExt = null;
            block5: while (!done) {
                switch (parser.next()) {
                    case 2: {
                        String transportNs;
                        String elementName = parser.getName();
                        if (!ConferenceDescriptionPacketExtension.TRANSPORT_ELEM_NAME.equals(elementName) || (transportNs = parser.getNamespace()) == null) continue block5;
                        transportExt = new TransportPacketExtension(transportNs);
                        break;
                    }
                    case 3: {
                        String elementName = parser.getName();
                        if (ConferenceDescriptionPacketExtension.ELEMENT_NAME.equals(elementName)) {
                            done = true;
                            break;
                        }
                        if (!ConferenceDescriptionPacketExtension.TRANSPORT_ELEM_NAME.equals(elementName) || transportExt == null) continue block5;
                        packetExtension.addChildExtension(transportExt);
                    }
                }
            }
            return packetExtension;
        }
    }

    public static class TransportPacketExtension
    extends AbstractPacketExtension {
        public TransportPacketExtension(String namespace) {
            super(namespace, ConferenceDescriptionPacketExtension.TRANSPORT_ELEM_NAME);
        }
    }
}

