/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.HashMap;
import net.java.sip.communicator.impl.osgi.framework.launch.FrameworkFactoryImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import org.ice4j.stack.StunStack;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.util.IQUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ProviderManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.xmpp.component.AbstractComponent;
import org.xmpp.component.Component;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class ComponentImpl
extends AbstractComponent
implements BundleActivator {
    private static final String[][] BUNDLES = new String[][]{{"net/java/sip/communicator/impl/libjitsi/LibJitsiActivator"}, {"net/java/sip/communicator/util/UtilActivator", "net/java/sip/communicator/impl/fileaccess/FileAccessActivator"}, {"net/java/sip/communicator/impl/configuration/ConfigurationActivator"}, {"net/java/sip/communicator/impl/resources/ResourceManagementActivator"}, {"net/java/sip/communicator/util/dns/DnsUtilActivator"}, {"net/java/sip/communicator/impl/netaddr/NetaddrActivator"}, {"net/java/sip/communicator/impl/packetlogging/PacketLoggingActivator"}, {"net/java/sip/communicator/service/gui/internal/GuiServiceActivator"}, {"net/java/sip/communicator/service/protocol/media/ProtocolMediaActivator"}, {"org/jitsi/videobridge/ComponentImplBundleActivator"}};
    private static final String DESCRIPTION = "Jitsi Videobridge Jabber Component";
    private static final String NAME = "JitsiVideobridge";
    public static final String SUBDOMAIN = "jitsi-videobridge";
    private BundleContext bundleContext;
    private Framework framework;
    private final Object frameworkSyncRoot = new Object();
    private Videobridge videobridge;

    protected String[] discoInfoFeatureNamespaces() {
        return new String[]{"http://jitsi.org/protocol/colibri", "urn:xmpp:jingle:apps:dtls:0", "urn:xmpp:jingle:transports:ice-udp:1", "urn:xmpp:jingle:transports:raw-udp:1"};
    }

    protected String discoInfoIdentityCategoryType() {
        return "conference";
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    private org.jivesoftware.smack.packet.IQ handleColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) throws Exception {
        ColibriConferenceIQ responseConferenceIQ;
        Conference conference;
        String id = conferenceIQ.getID();
        String focus = conferenceIQ.getFrom();
        Conference conference2 = conference = id == null ? this.videobridge.createConference(focus) : this.videobridge.getConference(id, focus);
        if (conference == null) {
            responseConferenceIQ = null;
        } else {
            responseConferenceIQ = new ColibriConferenceIQ();
            conference.describe(responseConferenceIQ);
            for (ColibriConferenceIQ.Content contentIQ : conferenceIQ.getContents()) {
                Content content = conference.getOrCreateContent(contentIQ.getName());
                if (content == null) {
                    responseConferenceIQ = null;
                } else {
                    ColibriConferenceIQ.Content responseContentIQ = new ColibriConferenceIQ.Content(content.getName());
                    responseConferenceIQ.addContent(responseContentIQ);
                    for (ColibriConferenceIQ.Channel channelIQ : contentIQ.getChannels()) {
                        String channelID = channelIQ.getID();
                        int channelExpire = channelIQ.getExpire();
                        Channel channel = channelID == null ? (channelExpire == 0 ? null : content.createChannel()) : content.getChannel(channelID);
                        if (channel == null) {
                            responseConferenceIQ = null;
                        } else {
                            Boolean initiator;
                            Integer lastN;
                            String endpoint;
                            RTPLevelRelayType rtpLevelRelayType;
                            if (channelExpire != -1) {
                                channel.setExpire(channelExpire);
                                if (channelExpire == 0 && channel.isExpired()) continue;
                            }
                            if ((rtpLevelRelayType = channelIQ.getRTPLevelRelayType()) != null) {
                                channel.setRTPLevelRelayType(rtpLevelRelayType);
                            }
                            if ((endpoint = channelIQ.getEndpoint()) != null) {
                                channel.setEndpoint(endpoint);
                            }
                            if ((lastN = channelIQ.getLastN()) != null) {
                                channel.setLastN(lastN);
                            }
                            if ((initiator = channelIQ.isInitiator()) != null) {
                                channel.setInitiator(initiator);
                            }
                            channel.setPayloadTypes(channelIQ.getPayloadTypes());
                            channel.setTransport(channelIQ.getTransport());
                            channel.setDirection(channelIQ.getDirection());
                            ColibriConferenceIQ.Channel responseChannelIQ = new ColibriConferenceIQ.Channel();
                            channel.describe(responseChannelIQ);
                            responseContentIQ.addChannel(responseChannelIQ);
                        }
                        if (responseConferenceIQ != null) continue;
                        break;
                    }
                }
                if (responseConferenceIQ != null) continue;
                break;
            }
        }
        if (responseConferenceIQ != null) {
            responseConferenceIQ.setType(IQ.Type.RESULT);
        }
        return responseConferenceIQ;
    }

    private IQ handleIQ(IQ iq) throws Exception {
        try {
            IQ resultIQ;
            ComponentImpl.logd("RECV: " + iq.toXML());
            org.jivesoftware.smack.packet.IQ smackIQ = IQUtils.convert(iq);
            org.jivesoftware.smack.packet.IQ resultSmackIQ = this.handleIQ(smackIQ);
            if (resultSmackIQ == null) {
                resultIQ = null;
            } else {
                resultIQ = IQUtils.convert(resultSmackIQ);
                ComponentImpl.logd("SENT: " + resultIQ.toXML());
            }
            return resultIQ;
        }
        catch (Exception e) {
            ComponentImpl.loge(e);
            throw e;
        }
    }

    private org.jivesoftware.smack.packet.IQ handleIQ(org.jivesoftware.smack.packet.IQ iq) throws Exception {
        org.jivesoftware.smack.packet.IQ resultIQ;
        if (iq instanceof ColibriConferenceIQ) {
            resultIQ = this.handleColibriConferenceIQ((ColibriConferenceIQ)iq);
            if (resultIQ != null) {
                resultIQ.setFrom(iq.getTo());
                resultIQ.setPacketID(iq.getPacketID());
                resultIQ.setTo(iq.getFrom());
            }
        } else {
            resultIQ = null;
        }
        return resultIQ;
    }

    protected IQ handleIQGet(IQ iq) throws Exception {
        IQ resultIQ = this.handleIQ(iq);
        return resultIQ == null ? super.handleIQGet(iq) : resultIQ;
    }

    protected IQ handleIQSet(IQ iq) throws Exception {
        IQ resultIQ = this.handleIQ(iq);
        return resultIQ == null ? super.handleIQSet(iq) : resultIQ;
    }

    private static void logd(String s) {
        System.err.println(s);
    }

    private static void loge(Throwable t) {
        t.printStackTrace(System.err);
    }

    public void postComponentShutdown() {
        super.postComponentShutdown();
        this.stopOSGi();
    }

    public void postComponentStart() {
        super.postComponentStart();
        String trueString = Boolean.toString(true);
        System.setProperty("net.java.sip.communicator.CONFIGURATION_FILE_IS_READ_ONLY", trueString);
        System.setProperty("net.java.sip.communicator.service.media.DISABLE_AUDIO_SUPPORT", trueString);
        System.setProperty("net.java.sip.communicator.service.media.DISABLE_VIDEO_SUPPORT", trueString);
        if (System.getProperty("net.java.sip.communicator.impl.neomedia.video.maxbandwidth") == null) {
            System.setProperty("net.java.sip.communicator.impl.neomedia.video.maxbandwidth", Integer.toString(Integer.MAX_VALUE));
        }
        this.startOSGi();
    }

    void send(org.jivesoftware.smack.packet.IQ iq) throws Exception {
        try {
            JID fromJID;
            String from = iq.getFrom();
            if ((from == null || from.length() == 0) && (fromJID = this.getJID()) != null) {
                iq.setFrom(fromJID.toString());
            }
            IQ packet = IQUtils.convert(iq);
            this.send((Packet)packet);
            ComponentImpl.logd("SENT: " + packet.toXML());
        }
        catch (Exception e) {
            ComponentImpl.loge(e);
            throw e;
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addIQProvider("conference", "http://jitsi.org/protocol/colibri", (Object)new ColibriIQProvider());
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:ice-udp:1", (Object)new DefaultPacketExtensionProvider(IceUdpTransportPacketExtension.class));
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:raw-udp:1", (Object)new DefaultPacketExtensionProvider(RawUdpTransportPacketExtension.class));
        DefaultPacketExtensionProvider candidatePacketExtensionProvider = new DefaultPacketExtensionProvider(CandidatePacketExtension.class);
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:ice-udp:1", (Object)candidatePacketExtensionProvider);
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:raw-udp:1", (Object)candidatePacketExtensionProvider);
        providerManager.addExtensionProvider("fingerprint", "urn:xmpp:jingle:apps:dtls:0", (Object)new DefaultPacketExtensionProvider(DtlsFingerprintPacketExtension.class));
        StunStack.setPacketLogger(null);
        this.videobridge = new Videobridge(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startOSGi() {
        Object object = this.frameworkSyncRoot;
        synchronized (object) {
            if (this.framework != null) {
                return;
            }
        }
        FrameworkFactoryImpl frameworkFactory = new FrameworkFactoryImpl();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.startlevel.beginning", Integer.toString(BUNDLES.length));
        Framework framework = frameworkFactory.newFramework(configuration);
        try {
            framework.init();
            BundleContext bundleContext = framework.getBundleContext();
            bundleContext.registerService(Component.class, (Object)this, null);
            for (int startLevelMinus1 = 0; startLevelMinus1 < BUNDLES.length; ++startLevelMinus1) {
                int startLevel = startLevelMinus1 + 1;
                for (String location : BUNDLES[startLevelMinus1]) {
                    BundleStartLevel bundleStartLevel;
                    Bundle bundle = bundleContext.installBundle(location);
                    if (bundle == null || (bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class)) == null) continue;
                    bundleStartLevel.setStartLevel(startLevel);
                }
            }
            framework.start();
        }
        catch (BundleException be) {
            throw new RuntimeException(be);
        }
        Object object2 = this.frameworkSyncRoot;
        synchronized (object2) {
            this.framework = framework;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.bundleContext == bundleContext) {
            this.bundleContext = null;
        }
        this.videobridge = null;
    }

    public Videobridge getVideoBridge() {
        return this.videobridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopOSGi() {
        Framework framework;
        Object object = this.frameworkSyncRoot;
        synchronized (object) {
            framework = this.framework;
            this.framework = null;
        }
        if (framework != null) {
            try {
                framework.stop();
            }
            catch (BundleException be) {
                throw new RuntimeException(be);
            }
        }
    }
}

