/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.txn;

import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionItem;
import com.hazelcast.collection.txn.CollectionTxnRemoveBackupOperation;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CollectionTxnRemoveOperation
extends CollectionBackupAwareOperation {
    private long itemId;
    private transient CollectionItem item;

    public CollectionTxnRemoveOperation() {
    }

    public CollectionTxnRemoveOperation(String name, long itemId) {
        super(name);
        this.itemId = itemId;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionTxnRemoveBackupOperation(this.name, this.itemId);
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_TXN_REMOVE;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.item = this.getOrCreateContainer().commitRemove(this.itemId);
    }

    @Override
    public void afterRun() throws Exception {
        if (this.item != null) {
            this.publishEvent(ItemEventType.REMOVED, (Data)this.item.getValue());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
    }
}

