/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.InstancePermission;

public class ListPermission
extends InstancePermission {
    private static final int ADD = 4;
    private static final int READ = 8;
    private static final int REMOVE = 22;
    private static final int LISTEN = 50;
    private static final int ALL = 63;

    public ListPermission(String name, String ... actions) {
        super(name, actions);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 0;
        for (int i = 0; i < actions.length; ++i) {
            if ("all".equals(actions[i])) {
                return 63;
            }
            if ("create".equals(actions[i])) {
                mask |= 1;
                continue;
            }
            if ("add".equals(actions[i])) {
                mask |= 4;
                continue;
            }
            if ("remove".equals(actions[i])) {
                mask |= 0x16;
                continue;
            }
            if ("read".equals(actions[i])) {
                mask |= 8;
                continue;
            }
            if ("destroy".equals(actions[i])) {
                mask |= 2;
                continue;
            }
            if (!"listen".equals(actions[i])) continue;
            mask |= 0x32;
        }
        return mask;
    }
}

