/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.multimap.operations.ClearOperation;
import com.hazelcast.multimap.operations.ContainsEntryOperation;
import com.hazelcast.multimap.operations.EntrySetOperation;
import com.hazelcast.multimap.operations.KeySetOperation;
import com.hazelcast.multimap.operations.SizeOperation;
import com.hazelcast.multimap.operations.ValuesOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;

public class MultiMapOperationFactory
implements OperationFactory {
    private String name;
    private OperationFactoryType operationFactoryType;
    private Data key;
    private Data value;

    public MultiMapOperationFactory() {
    }

    public MultiMapOperationFactory(String name, OperationFactoryType operationFactoryType) {
        this.name = name;
        this.operationFactoryType = operationFactoryType;
    }

    public MultiMapOperationFactory(String name, OperationFactoryType operationFactoryType, Data key, Data value) {
        this(name, operationFactoryType);
        this.key = key;
        this.value = value;
    }

    @Override
    public Operation createOperation() {
        if (this.operationFactoryType == OperationFactoryType.KEY_SET) {
            return new KeySetOperation(this.name);
        }
        if (this.operationFactoryType == OperationFactoryType.VALUES) {
            return new ValuesOperation(this.name);
        }
        if (this.operationFactoryType == OperationFactoryType.ENTRY_SET) {
            return new EntrySetOperation(this.name);
        }
        if (this.operationFactoryType == OperationFactoryType.CONTAINS) {
            return new ContainsEntryOperation(this.name, this.key, this.value);
        }
        if (this.operationFactoryType == OperationFactoryType.SIZE) {
            return new SizeOperation(this.name);
        }
        if (this.operationFactoryType == OperationFactoryType.CLEAR) {
            return new ClearOperation(this.name);
        }
        return null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.operationFactoryType.type);
        IOUtil.writeNullableData(out, this.key);
        IOUtil.writeNullableData(out, this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.operationFactoryType = OperationFactoryType.getByType(in.readInt());
        this.key = IOUtil.readNullableData(in);
        this.value = IOUtil.readNullableData(in);
    }

    public static enum OperationFactoryType {
        KEY_SET(1),
        VALUES(2),
        ENTRY_SET(3),
        CONTAINS(4),
        SIZE(5),
        CLEAR(6);

        final int type;

        private OperationFactoryType(int type) {
            this.type = type;
        }

        static OperationFactoryType getByType(int type) {
            for (OperationFactoryType factoryType : OperationFactoryType.values()) {
                if (factoryType.type != type) continue;
                return factoryType;
            }
            return null;
        }
    }
}

