/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.jingle;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.jnodes.jingle.Jingle;
import org.xmpp.jnodes.jingle.JingleContent;
import org.xmpp.jnodes.jingle.JingleDescription;
import org.xmpp.jnodes.jingle.JingleElement;
import org.xmpp.jnodes.jingle.JingleInfoRing;
import org.xmpp.jnodes.jingle.JinglePayloadType;
import org.xmpp.jnodes.jingle.JingleRawUdpCandidate;
import org.xmpp.jnodes.jingle.JingleRawUdpTransport;

public class JingleIQ
extends IQ
implements IQProvider {
    final Jingle jingle;
    static final List<Class> parsingClasses;

    public JingleIQ(Jingle jingle) {
        this.setType(IQ.Type.SET);
        this.jingle = jingle;
    }

    public String getChildElementXML() {
        return this.jingle.getChildElementXML();
    }

    public Jingle getJingle() {
        return this.jingle;
    }

    public JingleIQ parseIQ(XmlPullParser parser) throws XmlPullParserException, IOException {
        JingleIQ iq = null;
        boolean done = false;
        ArrayList<JingleElement> objects = new ArrayList<JingleElement>(10);
        JingleElement first = null;
        while (!done) {
            int eventType = parser.getEventType();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                for (Class c : parsingClasses) {
                    if (!elementName.equals(JingleElement.getStaticElementName(c))) continue;
                    String expectedNamespace = JingleElement.getNamespace(c);
                    if (namespace != null && expectedNamespace != null && !namespace.equals(expectedNamespace)) continue;
                    try {
                        Object o = c.newInstance();
                        if (first == null) {
                            first = (JingleElement)o;
                        }
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            try {
                                String n = parser.getAttributeName(i);
                                String v = parser.getAttributeValue(i);
                                Method m = c.getMethod("set" + Character.toUpperCase(n.charAt(0)) + n.substring(1), String.class);
                                m.invoke(o, v);
                                continue;
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                                continue;
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                        objects.add((JingleElement)o);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            } else if (eventType == 3 && elementName.equals(first.getElementName())) {
                done = true;
            }
            if (done) continue;
            parser.next();
        }
        System.out.println(objects.size());
        if (objects.size() > 0) {
            JingleElement child = null;
            JingleElement root = (JingleElement)objects.get(0);
            if (root instanceof Jingle) {
                if (objects.size() > 1) {
                    for (int i = 0; i < objects.size() - 1; ++i) {
                        for (JingleElement object : objects) {
                            JingleElement parent = (JingleElement)objects.get(i);
                            child = object;
                            String n = child.getElementName().replace("-", "");
                            String nn = Character.toUpperCase(n.charAt(0)) + n.substring(1);
                            Method m = null;
                            try {
                                m = parent.getClass().getMethod("set" + nn, child.getClass());
                            }
                            catch (NoSuchMethodException e) {
                                // empty catch block
                            }
                            try {
                                m = parent.getClass().getMethod("add" + nn, child.getClass());
                            }
                            catch (NoSuchMethodException e) {
                                // empty catch block
                            }
                            if (m == null) continue;
                            try {
                                m.invoke((Object)parent, child);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                iq = new JingleIQ((Jingle)root);
            }
        }
        return iq;
    }

    public static void enableJingle(XMPPConnection connection) {
        ProviderManager.getInstance().addIQProvider("jingle", "urn:xmpp:tmp:jingle", (Object)new JingleIQ(new Jingle()));
        Presence presence = new Presence(Presence.Type.available);
        presence.addExtension(new PacketExtension(){

            public String getElementName() {
                return "c";
            }

            public String getNamespace() {
                return "http://jabber.org/protocol/caps";
            }

            public String toXML() {
                return "<c xmlns=\"http://jabber.org/protocol/caps\" node=\"client:caps\" ver=\"0.1\" ext=\"jingle-v1 voice-v1\"></c>";
            }
        });
        for (int i = 0; i < 3; ++i) {
            connection.sendPacket((Packet)presence);
        }
    }

    static {
        Class[] classes;
        parsingClasses = new ArrayList<Class>();
        for (Class c : classes = new Class[]{Jingle.class, JingleContent.class, JingleDescription.class, JingleElement.class, JinglePayloadType.class, JingleRawUdpCandidate.class, JingleRawUdpTransport.class, JingleInfoRing.class}) {
            Class sup = c.getSuperclass();
            if (sup == null || !sup.equals(JingleElement.class)) continue;
            parsingClasses.add(c);
        }
    }
}

