/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.clientstate.Member;
import f00f.net.irc.martyr.commands.AbstractCommand;
import f00f.net.irc.martyr.util.FullNick;
import java.util.Enumeration;

public class NickCommand
extends AbstractCommand {
    private FullNick oldNick;
    private FullNick newNick;

    public NickCommand() {
        this(null, null);
    }

    public NickCommand(FullNick oldNick, FullNick newNick) {
        this.oldNick = oldNick;
        this.newNick = newNick;
    }

    public NickCommand(String newNick) {
        this(null, new FullNick(newNick));
    }

    public InCommand parse(String prefix, String identifier, String params) {
        return new NickCommand(new FullNick(prefix), new FullNick(this.getParameter(params, 0)));
    }

    public String getIrcIdentifier() {
        return "NICK";
    }

    public String renderParams() {
        return this.getNick();
    }

    public String getNick() {
        return this.newNick.getNick();
    }

    public String getOldNick() {
        return this.oldNick.getNick();
    }

    public boolean updateClientState(ClientState state) {
        if (this.oldNick.equals(state.getNick())) {
            state.setNick(this.newNick);
            return true;
        }
        Enumeration channels = state.getChannels();
        while (channels.hasMoreElements()) {
            Channel channel = (Channel)channels.nextElement();
            Member member = channel.findMember(this.oldNick.getNick());
            if (member == null) continue;
            member.setNick(this.newNick);
        }
        return false;
    }
}

