/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryOperation;
import com.hazelcast.map.impl.query.QueryPartitionOperation;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.Target;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

final class QueryDispatcher {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final InternalSerializationService serializationService;
    protected final IPartitionService partitionService;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final LocalMapStatsProvider localMapStatsProvider;
    protected final ManagedExecutorService executor;

    protected QueryDispatcher(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        this.executor = this.nodeEngine.getExecutionService().getExecutor("hz:query");
    }

    protected List<Future<Result>> dispatchFullQueryOnQueryThread(Query query, Target target) {
        if (target.isTargetAllNodes()) {
            return this.dispatchFullQueryOnAllMembersOnQueryThread(query);
        }
        if (target.isTargetLocalNode()) {
            return this.dispatchFullQueryOnLocalMemberOnQueryThread(query);
        }
        throw new IllegalArgumentException("Illegal target " + query);
    }

    private List<Future<Result>> dispatchFullQueryOnLocalMemberOnQueryThread(Query query) {
        MapOperation operation = this.mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryOperation(query);
        InternalCompletableFuture result = this.operationService.invokeOnTarget("hz:impl:mapService", operation, this.nodeEngine.getThisAddress());
        return Collections.singletonList(result);
    }

    private List<Future<Result>> dispatchFullQueryOnAllMembersOnQueryThread(Query query) {
        Collection<Member> members = this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<Future<Result>> futures = new ArrayList<Future<Result>>(members.size());
        for (Member member : members) {
            Operation operation = this.createQueryOperation(query, this.clusterService.getClusterVersion());
            InternalCompletableFuture future = this.operationService.invokeOnTarget("hz:impl:mapService", operation, member.getAddress());
            futures.add(future);
        }
        return futures;
    }

    private Operation createQueryOperation(Query query, Version clusterVersion) {
        boolean isVersion39orGreater = clusterVersion.isGreaterOrEqual(Versions.V3_9);
        if (isVersion39orGreater) {
            return this.mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryOperation(query);
        }
        return new QueryOperation(query);
    }

    protected List<Future<Result>> dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(Query query, BitSet partitionIds) {
        if (QueryDispatcher.shouldSkipPartitionsQuery(partitionIds)) {
            return Collections.emptyList();
        }
        ArrayList<Future<Result>> futures = new ArrayList<Future<Result>>(partitionIds.size());
        for (int partitionId = 0; partitionId < partitionIds.length(); ++partitionId) {
            if (!partitionIds.get(partitionId)) continue;
            futures.add(this.dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(query, partitionId));
        }
        return futures;
    }

    protected Future<Result> dispatchPartitionScanQueryOnOwnerMemberOnPartitionThread(Query query, int partitionId) {
        Operation op = this.createQueryPartitionOperation(query, this.clusterService.getClusterVersion());
        op.setPartitionId(partitionId);
        try {
            return this.operationService.invokeOnPartition("hz:impl:mapService", op, partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private Operation createQueryPartitionOperation(Query query, Version clusterVersion) {
        boolean isVersion39orGreater = clusterVersion.isGreaterOrEqual(Versions.V3_9);
        if (isVersion39orGreater) {
            return this.mapServiceContext.getMapOperationProvider(query.getMapName()).createQueryPartitionOperation(query);
        }
        return new QueryPartitionOperation(query);
    }

    private static boolean shouldSkipPartitionsQuery(BitSet partitionIds) {
        return partitionIds == null || partitionIds.isEmpty();
    }
}

