/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctCommand;

public class AcctInfoRequest
extends AcctCommand {
    public static final int TYPE_SN = 1;
    public static final int TYPE_EMAIL = 17;
    public static final int TYPE_SOMETHING = 19;
    public static final int SUBTYPE_DEFAULT = 0;
    private final int type;
    private final int subType;

    protected AcctInfoRequest(SnacPacket packet) {
        super(2);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.type = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
        this.subType = BinaryTools.getUShort((ByteBlock)snacData, (int)2);
    }

    public AcctInfoRequest(int type) {
        this(type, 0);
    }

    public AcctInfoRequest(int type, int subType) {
        super(2);
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        DefensiveTools.checkRange((int)subType, (String)"subType", (int)0);
        this.type = type;
        this.subType = subType;
    }

    public final int getType() {
        return this.type;
    }

    public final int getSubType() {
        return this.subType;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.type);
        BinaryTools.writeUShort((OutputStream)out, (int)this.subType);
    }

    public String toString() {
        return "InfoRequest: type=" + this.type + ", subtype=" + this.subType;
    }
}

