/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.DataInputStream;
import java.security.NoSuchAlgorithmException;
import ymsg.network.ChallengeResponseUtility;
import ymsg.network.ChallengeResponseV10Tables;
import ymsg.network.SHA1;

class ChallengeResponseV10
extends ChallengeResponseUtility
implements ChallengeResponseV10Tables {
    private static final String ALPHANUM_LOOKUP = "qzec2tb3um1olpar8whx4dfgijknsvy5";
    private static final String OPERATORS_LOOKUP = "+|&%/*^-";
    private static final String ENCODE1_LOOKUP = "FBZDWAGHrJTLMNOPpRSKUVEXYChImkwQ";
    private static final String ENCODE2_LOOKUP = "F0E1D2C3B4A59687abcdefghijklmnop";
    private static final String ENCODE3_LOOKUP = ",;";
    private static final boolean DB = false;
    private static final boolean DB2 = false;
    private static byte[] data;
    private static final String BIN_FILE = "challenge.bin";

    ChallengeResponseV10() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getStrings(String string, String string2, String string3) throws NoSuchAlgorithmException {
        Object object;
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < string3.length(); ++n3) {
            if (!ChallengeResponseV10.isOperator(string3.charAt(n3))) continue;
            ++n5;
        }
        int[] nArray = new int[n5];
        n5 = 0;
        for (n3 = 0; n3 < string3.length(); ++n3) {
            n2 = string3.charAt(n3);
            if (Character.isLetter((char)n2) || Character.isDigit((char)n2)) {
                n4 = ALPHANUM_LOOKUP.indexOf(n2) << 3;
                continue;
            }
            if (!ChallengeResponseV10.isOperator((char)n2)) continue;
            n = OPERATORS_LOOKUP.indexOf(n2);
            nArray[n5] = (n4 | n) & 0xFF;
            ++n5;
        }
        for (n3 = nArray.length - 2; n3 >= 0; --n3) {
            n2 = nArray[n3];
            n = nArray[n3 + 1];
            nArray[n3 + 1] = n2 = (n2 * 205 ^ n) & 0xFF;
        }
        byte[] byArray = ChallengeResponseV10._part3Munge(nArray);
        long l = 0L;
        byte[] byArray2 = new byte[7];
        for (n3 = 0; n3 < 4; ++n3) {
            l <<= 8;
            l += (long)(byArray[3 - n3] & 0xFF);
            byArray2[n3] = (byte)(byArray[n3] & 0xFF);
        }
        int n6 = 0;
        int n7 = 0;
        Object object2 = md5Obj;
        synchronized (object2) {
            for (n3 = 0; n3 < 65535; ++n3) {
                for (int i = 0; i < 5; ++i) {
                    byArray2[4] = (byte)(n3 & 0xFF);
                    byArray2[5] = (byte)(n3 >> 8 & 0xFF);
                    byArray2[6] = (byte)i;
                    object = ChallengeResponseV10.md5Singleton(byArray2);
                    if (!ChallengeResponseV10._part3Compare(object, byArray)) continue;
                    n7 = n3;
                    n6 = i;
                    n3 = 65535;
                    i = 5;
                }
            }
        }
        object2 = new byte[4];
        l = ChallengeResponseV10._part3Lookup(n6, n7, l);
        l = ChallengeResponseV10._part3Lookup(n6, n7, l);
        for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
            object2[n3] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        String string4 = ChallengeResponseV10.yahoo64(ChallengeResponseV10.md5(string2));
        object = ChallengeResponseV10.yahoo64(ChallengeResponseV10.md5(ChallengeResponseV10.md5Crypt(string2, "$1$_2S43d5f")));
        boolean bl = n6 >= 3;
        String[] stringArray = new String[]{ChallengeResponseV10._part4Encode(ChallengeResponseV10._part4Hash(string4, (byte[])object2, bl)), ChallengeResponseV10._part4Encode(ChallengeResponseV10._part4Hash((String)object, (byte[])object2, bl))};
        return stringArray;
    }

    private static byte[] _part3Munge(int[] nArray) {
        int n = 1;
        byte[] byArray = new byte[20];
        try {
            for (int i = 0; i < byArray.length; i += 2) {
                int n2;
                int n3;
                if ((n3 = nArray[n++]) <= 127) {
                    n2 = n3;
                } else {
                    if (n3 >= 224) {
                        int n4 = nArray[n++];
                        n3 = (n3 & 0xF) << 6;
                        n2 = n3 + (n4 &= 0x3F) << 6;
                    } else {
                        n2 = (n3 & 0x1F) << 6;
                    }
                    n2 += nArray[n++] & 0x3F;
                }
                byArray[i] = (byte)((n2 & 0xFF00) >> 8);
                byArray[i + 1] = (byte)(n2 & 0xFF);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        return byArray;
    }

    private static int _part3Lookup(int n, int n2, long l) {
        char c = '\u0000';
        long l2 = l;
        int n3 = (int)l;
        for (int i = 0; i < n2; ++i) {
            long l3;
            int n4;
            long l4;
            if (n == 0) {
                return n3;
            }
            if (l2 < 0L) {
                l2 += 0x100000000L;
            }
            int[] nArray = OPS[n][(int)(l2 % 96L)];
            switch (nArray[0]) {
                case 2: {
                    n3 ^= nArray[1];
                    break;
                }
                case 3: {
                    n3 = n3 * nArray[1] + nArray[2];
                    break;
                }
                case 4: {
                    c = TABLE_OFFSETS[nArray[1]];
                    long l5 = ChallengeResponseV10._data(c, n3 & 0xFF) | ChallengeResponseV10._data(c, n3 >> 8 & 0xFF) << 8 | ChallengeResponseV10._data(c, n3 >> 16 & 0xFF) << 16 | ChallengeResponseV10._data(c, n3 >> 24 & 0xFF) << 24;
                    n3 = (int)l5;
                    break;
                }
                case 5: {
                    long l5;
                    c = TABLE_OFFSETS[nArray[1]];
                    l4 = 0L;
                    for (n4 = 0; n4 < 32; ++n4) {
                        l3 = (n3 >> n4 & 1) << ChallengeResponseV10._data(c, n4);
                        l5 = (long)(~(1 << ChallengeResponseV10._data(c, n4))) & l4;
                        l4 = l3 | l5;
                    }
                    n3 = (int)l4;
                }
            }
            if (n2 - i <= 1) {
                return n3;
            }
            l3 = 0L;
            l4 = n3;
            for (n4 = 0; n4 < 4; ++n4) {
                l3 = (l3 ^ l4 & 0xFFL) * -1640531535L;
                l4 >>= 8;
            }
            l2 = (int)((l3 ^ l3 >> 8) >> 16 ^ l3 ^ l3 >> 8) & 0xFF;
            n3 *= 69069;
        }
        return n3;
    }

    private static final int _data(int n, int n2) {
        return data[n + n2] & 0xFF;
    }

    private static final boolean _part3Compare(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < 16; ++i) {
            if (byArray[i] == byArray2[i + 4]) continue;
            return false;
        }
        return true;
    }

    private static String _part4Encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; i += 2) {
            int n = ((byArray[i] & 0xFF) << 8) + (byArray[i + 1] & 0xFF);
            stringBuffer.append(ENCODE1_LOOKUP.charAt(n >> 11 & 0x1F));
            stringBuffer.append('=');
            stringBuffer.append(ENCODE2_LOOKUP.charAt(n >> 6 & 0x1F));
            stringBuffer.append(ENCODE2_LOOKUP.charAt(n >> 1 & 0x1F));
            stringBuffer.append(ENCODE3_LOOKUP.charAt(n & 1));
        }
        return stringBuffer.toString();
    }

    private static byte[] _part4Hash(String string, byte[] byArray, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray2 = ChallengeResponseV10._part4Xor(string, 54);
        byte[] byArray3 = ChallengeResponseV10._part4Xor(string, 92);
        SHA1 sHA1 = new SHA1();
        sHA1.update(byArray2);
        if (bl) {
            sHA1.setBitCount(511L);
        }
        sHA1.update(byArray);
        byte[] byArray4 = sHA1.digest();
        sHA1.reset();
        sHA1.update(byArray3);
        sHA1.update(byArray4);
        byte[] byArray5 = sHA1.digest();
        return byArray5;
    }

    private static byte[] _part4Xor(String string, int n) {
        int n2;
        byte[] byArray = new byte[64];
        for (n2 = 0; n2 < string.length(); ++n2) {
            byArray[n2] = (byte)(string.charAt(n2) ^ n);
        }
        for (n2 = string.length(); n2 < byArray.length; ++n2) {
            byArray[n2] = (byte)n;
        }
        return byArray;
    }

    private static boolean isOperator(char c) {
        return OPERATORS_LOOKUP.indexOf(c) >= 0;
    }

    static void dump(String string, int[] nArray) {
        int n = 0;
        System.out.println(string);
        while (n < nArray.length) {
            String string2 = Integer.toHexString(nArray[n]);
            if (string2.length() < 2) {
                string2 = "0" + string2;
            }
            System.out.print(string2 + " ");
            if (++n % 20 != 0) continue;
            System.out.print("\n");
        }
        if (n % 20 != 0) {
            System.out.print("\n");
        }
    }

    static void dump(String string, byte[] byArray) {
        int n = 0;
        System.out.println(string);
        while (n < byArray.length) {
            String string2 = Integer.toHexString(byArray[n] & 0xFF);
            if (string2.length() < 2) {
                string2 = "0" + string2;
            }
            System.out.print(string2 + " ");
            if (++n % 20 != 0) continue;
            System.out.print("\n");
        }
        if (n % 20 != 0) {
            System.out.print("\n");
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("ymsg.network.ChallengeResponseV10");
            DataInputStream dataInputStream = new DataInputStream(clazz.getResourceAsStream(BIN_FILE));
            data = new byte[dataInputStream.available()];
            if (data.length < TABLE_OFFSETS[TABLE_OFFSETS.length - 1]) {
                throw new Exception("Data too short?");
            }
            dataInputStream.readFully(data);
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error loading resource file: challenge.bin");
            exception.printStackTrace();
        }
    }
}

