/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.HashMap;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;

public class RvConnectionSettings {
    private static final long DEFAULT_RV_CONNECTION_TIMEOUT = 10000L;
    public static final long DEFAULT_LAN_TIMEOUT = 2000L;
    public static final long DEFAULT_INTERNET_TIMEOUT = 3000L;
    public static final long DEFAULT_INCOMING_MODIFICATION = 2000L;
    private boolean onlyUsingProxy = false;
    private boolean proxyRequestTrusted = true;
    private long perConnectionTimeout = 10000L;
    private Map<ConnectionType, Long> timeouts = new HashMap<ConnectionType, Long>();
    private Map<Initiator, Long> timeoutModifications = new HashMap<Initiator, Long>();
    private AimProxyInfo proxyInfo = AimProxyInfo.forNoProxy();

    public RvConnectionSettings() {
        this.timeouts.put(ConnectionType.LAN, 2000L);
        this.timeouts.put(ConnectionType.INTERNET, 3000L);
        this.timeoutModifications.put(Initiator.BUDDY, 2000L);
    }

    public synchronized AimProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public synchronized void setProxyInfo(AimProxyInfo proxyInfo) {
        this.proxyInfo = proxyInfo;
    }

    public synchronized boolean isProxyRequestTrusted() {
        return this.proxyRequestTrusted;
    }

    public synchronized void setProxyRequestTrusted(boolean trusted) {
        this.proxyRequestTrusted = trusted;
    }

    public synchronized boolean isOnlyUsingProxy() {
        return this.onlyUsingProxy;
    }

    public synchronized void setOnlyUsingProxy(boolean onlyUsingProxy) {
        this.onlyUsingProxy = onlyUsingProxy;
    }

    public synchronized void setDefaultPerConnectionTimeout(long millis) {
        this.perConnectionTimeout = millis;
    }

    public synchronized long getDefaultPerConnectionTimeout(Initiator initiator) {
        return this.perConnectionTimeout + this.getTimeoutModification(initiator);
    }

    public synchronized void setTimeoutModification(Initiator initiator, Long mod) {
        this.timeoutModifications.put(initiator, mod);
    }

    public synchronized long getTimeoutModification(Initiator initiator) {
        Long mod = this.timeoutModifications.get((Object)initiator);
        if (mod == null) {
            return 0L;
        }
        return mod;
    }

    public synchronized void setPerConnectionTimeout(ConnectionType type, long millis) {
        this.timeouts.put(type, millis);
    }

    public synchronized long getPerConnectionTimeout(Initiator initiator, ConnectionType type) {
        DefensiveTools.checkNull((Object)((Object)type), (String)"type");
        Long timeout = this.timeouts.get((Object)type);
        if (timeout == null) {
            return this.getDefaultPerConnectionTimeout(initiator);
        }
        return timeout + this.getTimeoutModification(initiator);
    }
}

