/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.msnftp;

import net.sf.jml.MsnProtocol;
import net.sf.jml.protocol.msnftp.MsnftpMessage;
import net.sf.jml.protocol.msnftp.MsnftpSession;
import net.sf.jml.protocol.msnftp.MsnftpUSR;

public class MsnftpVER
extends MsnftpMessage {
    public MsnftpVER(MsnProtocol msnProtocol) {
        super(msnProtocol);
        this.setCommand("VER");
    }

    public void setSupportedFTP(boolean bl) {
        this.setParam(0, bl ? "MSNFTP" : "");
    }

    public boolean isSupportedFTP() {
        for (int i = 0; i < this.getParamCount(); ++i) {
            String string = this.getParam(i);
            if (!"MSNFTP".equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void messageReceived(MsnftpSession msnftpSession) {
        super.messageReceived(msnftpSession);
        if (msnftpSession.getFileTransfer().isSender()) {
            if (this.isSupportedFTP()) {
                MsnftpVER msnftpVER = new MsnftpVER(this.protocol);
                msnftpVER.setSupportedFTP(true);
                msnftpSession.sendAsynchronousMessage(msnftpVER);
            } else {
                msnftpSession.close();
            }
        } else {
            MsnftpUSR msnftpUSR = new MsnftpUSR(this.protocol);
            msnftpUSR.setEmail(msnftpSession.getFileTransfer().getMessenger().getOwner().getEmail());
            msnftpSession.sendAsynchronousMessage(msnftpUSR);
        }
    }
}

