/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar;

import java.util.Timer;
import java.util.TimerTask;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.login.LoginService;

public class LoginConnection
extends OscarConnection {
    public static final int TIMEOUT_DEFAULT = 15;
    private int timeoutSecs = 15;
    private Timer timer = new Timer(true);

    public LoginConnection(String host, int port) {
        super(host, port);
    }

    public synchronized void setTimeoutSecs(int timeoutSecs) {
        this.checkFieldModify();
        DefensiveTools.checkRange((int)timeoutSecs, (String)"timeoutSecs", (int)0);
        this.timeoutSecs = timeoutSecs;
    }

    public synchronized int getTimeout() {
        return this.timeoutSecs;
    }

    private void cancelLogin() {
        LoginService ls = this.getLoginService();
        if (ls != null) {
            ls.timeout(this.getTimeout());
        }
        this.disconnect();
    }

    protected void beforeConnect() {
        this.setSnacFamilies(23);
        int secs = this.getTimeout();
        this.timer.schedule(new TimerTask(){

            public void run() {
                LoginConnection.this.cancelLogin();
            }
        }, secs * 1000);
    }

    protected void disconnected() {
        this.timer.cancel();
    }

    public LoginService getLoginService() {
        Service service = this.getService(23);
        if (service instanceof LoginService) {
            return (LoginService)service;
        }
        return null;
    }
}

