/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import javax.sip.address.Hop;

public abstract class SIPTransactionStack
extends SIPMessageStack
implements SIPTransactionEventListener {
    public static final int BASE_TIMER_INTERVAL = 500;
    public static final int CONNECTION_LINGER_TIME = 32;
    private List clientTransactions;
    private List serverTransactions;
    protected Hashtable dialogTable;
    protected int transactionTableSize = -1;
    protected boolean retransmissionFilter;
    protected HashSet dialogCreatingMethods = new HashSet();
    private int activeClientTransactionCount;
    private int activeServerTransactionCount;
    protected Timer timer;
    protected Thread pendingRecordScanner;
    private HashSet pendingTransactions;
    private List pendingRecords;
    private Hashtable clientTransactionTable;
    private Hashtable serverTransactionTable;

    protected SIPTransactionStack() {
        this.dialogCreatingMethods.add("REFER");
        this.dialogCreatingMethods.add("INVITE");
        this.dialogCreatingMethods.add("SUBSCRIBE");
        this.clientTransactions = Collections.synchronizedList(new ArrayList());
        this.serverTransactions = Collections.synchronizedList(new ArrayList());
        this.dialogTable = new Hashtable();
        this.clientTransactionTable = new Hashtable();
        this.serverTransactionTable = new Hashtable();
        this.timer = new Timer();
        this.pendingRecordScanner = new Thread(new PendingRecordScanner(this));
        this.pendingRecordScanner.setDaemon(true);
        this.pendingTransactions = new HashSet();
        this.pendingRecords = Collections.synchronizedList(new ArrayList());
        this.pendingRecordScanner.setName("PendingRecordScanner");
        this.pendingRecordScanner.start();
    }

    protected void reInit() {
        super.reInit();
        this.clientTransactions = Collections.synchronizedList(new ArrayList());
        this.serverTransactions = Collections.synchronizedList(new ArrayList());
        this.pendingTransactions = new HashSet();
        this.pendingRecords = Collections.synchronizedList(new ArrayList());
        this.clientTransactionTable = new Hashtable();
        this.serverTransactionTable = new Hashtable();
        this.dialogTable = new Hashtable();
        this.timer = new Timer();
        this.pendingRecordScanner = new Thread(new PendingRecordScanner(this));
        this.pendingRecordScanner.setDaemon(true);
        this.pendingRecordScanner.setName("PendingRecordScanner");
        this.pendingRecordScanner.start();
    }

    public boolean isDialogCreated(String method) {
        return this.dialogCreatingMethods.contains(method.toUpperCase());
    }

    public void addExtensionMethod(String extensionMethod) {
        if (extensionMethod.equals("NOTIFY")) {
            if (LogWriter.needsLogging) {
                this.logWriter.logMessage("NOTIFY Supported Natively");
            }
        } else {
            this.dialogCreatingMethods.add(extensionMethod.trim().toUpperCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDialog(SIPDialog dialog) {
        String dialogId = dialog.getDialogId();
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            if (this.dialogTable.containsKey(dialogId)) {
                return;
            }
        }
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("putDialog dialogId=" + dialogId);
        }
        dialog.setStack(this);
        if (LogWriter.needsLogging) {
            this.logWriter.logStackTrace();
        }
        hashtable = this.dialogTable;
        synchronized (hashtable) {
            this.dialogTable.put(dialogId, dialog);
        }
    }

    public SIPDialog createDialog(SIPTransaction transaction) {
        SIPDialog retval = new SIPDialog(transaction);
        return retval;
    }

    public Iterator getDialogs() {
        return this.dialogTable.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDialog(SIPDialog dialog) {
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            Iterator it = this.dialogTable.values().iterator();
            while (it.hasNext()) {
                SIPDialog d = (SIPDialog)it.next();
                if (d != dialog) continue;
                if (LogWriter.needsLogging) {
                    String dialogId = dialog.getDialogId();
                    this.logWriter.logMessage("Removing Dialog " + dialogId);
                }
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPDialog getDialog(String dialogId) {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("Getting dialog for " + dialogId);
        }
        Hashtable hashtable = this.dialogTable;
        synchronized (hashtable) {
            return (SIPDialog)this.dialogTable.get(dialogId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPClientTransaction findSubscribeTransaction(SIPRequest notifyMessage) {
        List list = this.clientTransactions;
        synchronized (list) {
            Iterator it = this.clientTransactions.iterator();
            String thisToTag = notifyMessage.getTo().getTag();
            if (thisToTag == null) {
                return null;
            }
            Event eventHdr = (Event)notifyMessage.getHeader("Event");
            if (eventHdr == null) {
                return null;
            }
            while (it.hasNext()) {
                SIPClientTransaction ct = (SIPClientTransaction)it.next();
                String fromTag = ct.from.getTag();
                Event hisEvent = ct.event;
                if (hisEvent == null || !ct.method.equals("SUBSCRIBE") || !fromTag.equalsIgnoreCase(thisToTag) || hisEvent == null || !eventHdr.match(hisEvent) || !notifyMessage.getCallId().getCallId().equalsIgnoreCase(ct.callId.getCallId())) continue;
                return ct;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPTransaction findTransaction(SIPMessage sipMessage, boolean isServer) {
        Object it2;
        SIPTransaction retval = null;
        if (isServer) {
            Object key;
            Via via = sipMessage.getTopmostVia();
            if (via.getBranch() != null) {
                key = sipMessage.getTransactionId();
                Hashtable hashtable = this.serverTransactionTable;
                synchronized (hashtable) {
                    retval = (SIPTransaction)this.serverTransactionTable.get(key);
                    if (LogWriter.needsLogging) {
                        this.logMessage("looking for key " + (String)key);
                    }
                    if (retval != null && retval.isMessagePartOfTransaction(sipMessage)) {
                        return retval;
                    }
                }
            }
            key = this.serverTransactions;
            synchronized (key) {
                Iterator it2 = this.serverTransactions.iterator();
                while (it2.hasNext()) {
                    SIPServerTransaction sipServerTransaction = (SIPServerTransaction)it2.next();
                    if (!sipServerTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                    return sipServerTransaction;
                }
            }
        }
        Via via = sipMessage.getTopmostVia();
        if (via.getBranch() != null) {
            String key = sipMessage.getTransactionId();
            it2 = this.clientTransactionTable;
            synchronized (it2) {
                retval = (SIPTransaction)this.clientTransactionTable.get(key);
                if (retval != null && retval.isMessagePartOfTransaction(sipMessage)) {
                    return retval;
                }
            }
        }
        List list = this.clientTransactions;
        synchronized (list) {
            it2 = this.clientTransactions.iterator();
            while (it2.hasNext()) {
                SIPClientTransaction clientTransaction = (SIPClientTransaction)it2.next();
                if (!clientTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                return clientTransaction;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPTransaction findCancelTransaction(SIPRequest cancelRequest, boolean isServer) {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("findCancelTransaction request= \n" + cancelRequest + "\nfindCancelRequest isServer=" + isServer);
        }
        if (isServer) {
            List list = this.serverTransactions;
            synchronized (list) {
                Iterator li = this.serverTransactions.iterator();
                while (li.hasNext()) {
                    SIPTransaction transaction = (SIPTransaction)li.next();
                    SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
                    SIPServerTransaction sipServerTransaction = (SIPServerTransaction)transaction;
                    if (!sipServerTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                    return sipServerTransaction;
                }
            }
        }
        List list = this.clientTransactions;
        synchronized (list) {
            Iterator li = this.clientTransactions.iterator();
            while (li.hasNext()) {
                SIPTransaction transaction = (SIPTransaction)li.next();
                SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
                SIPClientTransaction sipClientTransaction = (SIPClientTransaction)transaction;
                if (!sipClientTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipClientTransaction;
            }
        }
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("Could not find transaction for cancel request");
        }
        return null;
    }

    protected SIPTransactionStack(StackMessageFactory messageFactory) {
        this();
        this.sipMessageFactory = messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPServerTransaction findPendingTransaction(SIPRequest requestReceived) {
        SIPServerTransaction currentTransaction;
        HashSet hashSet = this.pendingTransactions;
        synchronized (hashSet) {
            Iterator transactionIterator = this.pendingTransactions.iterator();
            currentTransaction = null;
            while (transactionIterator.hasNext() && currentTransaction == null) {
                SIPServerTransaction nextTransaction = (SIPServerTransaction)transactionIterator.next();
                if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                currentTransaction = nextTransaction;
            }
        }
        return currentTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingTransaction(SIPServerTransaction tr) {
        HashSet hashSet = this.pendingTransactions;
        synchronized (hashSet) {
            this.pendingTransactions.remove(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerRequestInterface newSIPServerRequest(SIPRequest requestReceived, MessageChannel requestMessageChannel) {
        String key = requestReceived.getTransactionId();
        SIPServerTransaction currentTransaction = (SIPServerTransaction)this.serverTransactionTable.get(key);
        if (currentTransaction == null || !currentTransaction.isMessagePartOfTransaction(requestReceived)) {
            List list = this.serverTransactions;
            synchronized (list) {
                Iterator transactionIterator = this.serverTransactions.iterator();
                currentTransaction = null;
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPServerTransaction nextTransaction = (SIPServerTransaction)transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                    currentTransaction = nextTransaction;
                }
                if (currentTransaction == null) {
                    currentTransaction = this.findPendingTransaction(requestReceived);
                    if (currentTransaction != null) {
                        return currentTransaction;
                    }
                    currentTransaction = this.createServerTransaction(requestMessageChannel);
                    currentTransaction.setOriginalRequest(requestReceived);
                    if (!this.isDialogCreated(requestReceived.getMethod())) {
                        String dialogId = requestReceived.getDialogId(true);
                        SIPDialog dialog = this.getDialog(dialogId);
                        if (dialog != null && (requestReceived.getMethod().equals("ACK") || requestReceived.getCSeq().getSequenceNumber() > dialog.getRemoteSequenceNumber())) {
                            if (LogWriter.needsLogging) {
                                this.logWriter.logMessage("adding server transaction " + currentTransaction);
                            }
                            this.serverTransactions.add(0, currentTransaction);
                            this.addTransactionHash(currentTransaction);
                            currentTransaction.startTransactionTimer();
                            currentTransaction.isMapped = true;
                        }
                    } else {
                        String dialogId = requestReceived.getDialogId(true);
                        SIPDialog dialog = this.getDialog(dialogId);
                        if (dialog != null && requestReceived.getCSeq().getSequenceNumber() > dialog.getRemoteSequenceNumber()) {
                            currentTransaction.map();
                            if (LogWriter.needsLogging) {
                                this.logWriter.logMessage("adding server transaction " + currentTransaction);
                            }
                            this.serverTransactions.add(0, currentTransaction);
                            this.addTransactionHash(currentTransaction);
                            currentTransaction.startTransactionTimer();
                            currentTransaction.toListener = true;
                        }
                    }
                }
            }
        }
        currentTransaction.setRequestInterface(super.newSIPServerRequest(requestReceived, currentTransaction));
        return currentTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerResponseInterface newSIPServerResponse(SIPResponse responseReceived, MessageChannel responseMessageChannel) {
        String key = responseReceived.getTransactionId();
        SIPClientTransaction currentTransaction = (SIPClientTransaction)this.clientTransactionTable.get(key);
        if (currentTransaction == null || !currentTransaction.isMessagePartOfTransaction(responseReceived)) {
            List list = this.clientTransactions;
            synchronized (list) {
                Iterator transactionIterator = this.clientTransactions.iterator();
                currentTransaction = null;
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPClientTransaction nextTransaction = (SIPClientTransaction)transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(responseReceived)) continue;
                    currentTransaction = nextTransaction;
                }
            }
            if (currentTransaction == null) {
                return super.newSIPServerResponse(responseReceived, responseMessageChannel);
            }
        }
        currentTransaction.setResponseInterface(super.newSIPServerResponse(responseReceived, currentTransaction));
        return currentTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(int sourcePort, Hop nextHop) throws UnknownHostException {
        List list = this.clientTransactions;
        synchronized (list) {
            MessageChannel mc = super.createMessageChannel(sourcePort, nextHop);
            if (mc == null) {
                return null;
            }
            SIPClientTransaction returnChannel = this.createClientTransaction(mc);
            this.clientTransactions.add(0, returnChannel);
            returnChannel.setViaPort(nextHop.getPort());
            returnChannel.setViaHost(nextHop.getHost());
            ((SIPTransaction)returnChannel).startTransactionTimer();
            return returnChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(MessageChannel rawChannel) {
        List list = this.clientTransactions;
        synchronized (list) {
            SIPClientTransaction returnChannel = this.createClientTransaction(rawChannel);
            this.clientTransactions.add(0, returnChannel);
            returnChannel.setViaPort(rawChannel.getViaPort());
            returnChannel.setViaHost(rawChannel.getHost());
            ((SIPTransaction)returnChannel).startTransactionTimer();
            return returnChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageChannel createMessageChannel(SIPTransaction transaction) {
        List list = this.clientTransactions;
        synchronized (list) {
            SIPClientTransaction returnChannel = this.createClientTransaction(transaction.getMessageChannel());
            this.clientTransactions.add(0, returnChannel);
            returnChannel.setViaPort(transaction.getViaPort());
            returnChannel.setViaHost(transaction.getViaHost());
            ((SIPTransaction)returnChannel).startTransactionTimer();
            return returnChannel;
        }
    }

    public SIPClientTransaction createClientTransaction(MessageChannel encapsulatedMessageChannel) {
        return new SIPClientTransaction(this, encapsulatedMessageChannel);
    }

    public SIPServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        return new SIPServerTransaction(this, encapsulatedMessageChannel);
    }

    public MessageChannel createRawMessageChannel(int sourcePort, Hop hop) throws UnknownHostException {
        return super.createMessageChannel(sourcePort, hop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(SIPClientTransaction clientTransaction) {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("added transaction " + clientTransaction);
        }
        List list = this.clientTransactions;
        synchronized (list) {
            this.clientTransactions.add(0, clientTransaction);
        }
        this.addTransactionHash(clientTransaction);
        clientTransaction.startTransactionTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(SIPTransaction sipTransaction) {
        if (sipTransaction instanceof SIPServerTransaction) {
            Object object = this.serverTransactions;
            synchronized (object) {
                this.serverTransactions.remove(sipTransaction);
            }
            object = this.serverTransactionTable;
            synchronized (object) {
                String key = sipTransaction.getTransactionId();
                this.serverTransactionTable.remove(key);
            }
        }
        Object object = this.clientTransactions;
        synchronized (object) {
            this.clientTransactions.remove(sipTransaction);
        }
        object = this.clientTransactionTable;
        synchronized (object) {
            String key = sipTransaction.getTransactionId();
            this.clientTransactionTable.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(SIPServerTransaction serverTransaction) throws IOException {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("added transaction " + serverTransaction);
        }
        List list = this.serverTransactions;
        synchronized (list) {
            this.serverTransactions.add(0, serverTransaction);
            serverTransaction.map();
        }
        this.addTransactionHash(serverTransaction);
        serverTransaction.startTransactionTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        Via via = sipRequest.getTopmostVia();
        if (sipTransaction instanceof SIPClientTransaction) {
            Hashtable hashtable = this.clientTransactionTable;
            synchronized (hashtable) {
                String key = sipRequest.getTransactionId();
                this.clientTransactionTable.put(key, sipTransaction);
            }
        }
        Hashtable hashtable = this.serverTransactionTable;
        synchronized (hashtable) {
            String key = sipRequest.getTransactionId();
            this.serverTransactionTable.put(key, sipTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipRequest == null) {
            return;
        }
        if (sipTransaction instanceof SIPClientTransaction) {
            Hashtable hashtable = this.clientTransactionTable;
            synchronized (hashtable) {
                String key = sipTransaction.getTransactionId();
                this.clientTransactionTable.remove(key);
            }
        }
        if (sipTransaction instanceof SIPServerTransaction) {
            Hashtable hashtable = this.serverTransactionTable;
            synchronized (hashtable) {
                String key = sipTransaction.getTransactionId();
                this.serverTransactionTable.remove(key);
            }
        }
    }

    public boolean hasResources() {
        if (this.transactionTableSize == -1) {
            return true;
        }
        return this.serverTransactions.size() < this.transactionTableSize;
    }

    public synchronized void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            transaction.setState(SIPTransaction.TERMINATED_STATE);
            if (transaction instanceof SIPServerTransaction) {
                ((SIPServerTransaction)transaction).collectionTime = 0;
            }
            transaction.disableTimeoutTimer();
            transaction.disableRetransmissionTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPending(PendingRecord pendingRecord) {
        List list = this.pendingRecords;
        synchronized (list) {
            this.pendingRecords.add(pendingRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePending(PendingRecord pendingRecord) {
        List list = this.pendingRecords;
        synchronized (list) {
            this.pendingRecords.remove(pendingRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPendingRecordScanner() {
        List list = this.pendingRecords;
        synchronized (list) {
            this.pendingRecords.notify();
        }
    }

    public void stopStack() {
        this.notifyPendingRecordScanner();
        this.timer.cancel();
        this.pendingTransactions.clear();
        super.stopStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPendingTransaction(SIPServerTransaction tr) {
        HashSet hashSet = this.pendingTransactions;
        synchronized (hashSet) {
            this.pendingTransactions.add(tr);
        }
    }

    static /* synthetic */ List access$000(SIPTransactionStack x0) {
        return x0.pendingRecords;
    }

    class PendingRecordScanner
    implements Runnable {
        SIPTransactionStack myStack;

        protected PendingRecordScanner(SIPTransactionStack myStack) {
            this.myStack = myStack;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

