/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import org.hn.sleek.jmml.Message;

class OutgoingMessage
extends Message {
    static final int NO_TRANSACTION_ID = -1;

    public OutgoingMessage(int type, int transactionID) {
        this.type = type;
        this.transactionID = new Integer(transactionID);
    }

    public OutgoingMessage(int type) {
        this(type, -1);
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getMessageString() {
        String commandString = Message.commandToString(this.type) + " ";
        String transactionIDString = "";
        if (this.transactionID != -1) {
            transactionIDString = this.transactionID.toString();
        }
        String message = commandString + transactionIDString;
        switch (this.type) {
            case 24: {
                message = message + " " + this.arguments.get(0) + " " + this.arguments.get(1) + this.arguments.get(2) + this.arguments.get(3);
                return message;
            }
            case 19: {
                for (int i = 0; i < this.arguments.size(); ++i) {
                    message = message + " " + (String)this.arguments.get(i);
                }
                return message.trim() + "\r\n" + this.body;
            }
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            message = message + " " + (String)this.arguments.get(i);
        }
        return message.trim() + "\r\n";
    }

    public void addArgument(String argument) {
        this.arguments.add(argument);
    }

    public String toString() {
        return this.getMessageString();
    }

    public static void main(String[] args) {
        OutgoingMessage msg = new OutgoingMessage(2, 10);
        msg.addArgument("AL");
        msg.addArgument("example@passport.com");
        msg.addArgument("FirendlyName");
        System.out.println(msg);
        msg = new OutgoingMessage(3, 23);
        msg.addArgument("New%20Group");
        msg.addArgument("0");
        System.out.println(msg);
        msg = new OutgoingMessage(14, 1);
        System.out.println(msg);
        msg = new OutgoingMessage(22, -1);
        System.out.println(msg);
    }
}

