/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractChatInfo {
    public static final int TYPE_SHORT = 1;
    public static final int TYPE_FULL = 2;
    public static final int TYPE_INSTANCE_INFO = 4;
    public static final int TYPE_NAV_SHORT_DESC = 8;
    public static final int TYPE_NAV_INSTANCE_INFO = 16;
    public static final int PERM_CANNOT_CREATE_ANYTHING = 0;
    public static final int PERM_CAN_CREATE_ROOM = 1;
    public static final int PERM_CAN_CREATE_EXCHANGE = 2;
    public static final int MASK_WARNABLE = 1;
    public static final int MASK_NAV_ONLY = 2;
    public static final int MASK_INSTANCING_ALLOWED = 4;
    public static final int MASK_CAN_PEEK = 8;
    private static final int TYPE_FLAGS = 201;
    private static final int TYPE_CREATION_DATE = 202;
    private static final int TYPE_MAX_MSG_LEN = 209;
    private static final int TYPE_MAX_OCCUPANCY = 210;
    private static final int TYPE_NAME = 211;
    private static final int TYPE_CREATE_PERMS = 213;
    private static final int TYPE_CHARSET_1 = 214;
    private static final int TYPE_LANG_1 = 215;
    private static final int TYPE_CHARSET_2 = 216;
    private static final int TYPE_LANG_2 = 217;
    private static final int TYPE_SOMETHING = 218;
    private static final int TYPE_CONTENT_TYPE = 219;
    private int flags;
    private Date creation;
    private int maxMsgLen;
    private int maxOccupancy;
    private String name;
    private short createPerms;
    private String charset1;
    private String language1;
    private String charset2;
    private String language2;
    private String contentType;
    private int something;
    private MutableTlvChain tlvChain = null;

    protected AbstractChatInfo() {
    }

    protected AbstractChatInfo(String string, String string2, String string3) {
        this(string, string2, string3, "text/x-aolrtf");
    }

    protected AbstractChatInfo(String string, String string2, String string3, String string4) {
        this(-1, null, -1, -1, string, -1, string2, string3, null, null, string4);
    }

    protected AbstractChatInfo(String string) {
        this(string, null, null);
    }

    protected AbstractChatInfo(int n, Date date, int n2, int n3, String string, short s, String string2, String string3, String string4, String string5, String string6) {
        DefensiveTools.checkRange(n, "flags", -1);
        DefensiveTools.checkRange(n2, "maxMsgLen", -1);
        DefensiveTools.checkRange(n3, "maxOccupancy", -1);
        DefensiveTools.checkRange(s, "createPerms", -1);
        this.flags = n;
        this.creation = date;
        this.maxMsgLen = n2;
        this.maxOccupancy = n3;
        this.name = string;
        this.createPerms = s;
        this.charset1 = string2;
        this.language1 = string3;
        this.charset2 = string4;
        this.language2 = string5;
        this.contentType = string6;
    }

    protected final synchronized void readBaseInfo(TlvChain tlvChain) {
        long l;
        DefensiveTools.checkNull(tlvChain, "chain");
        this.flags = tlvChain.getUShort(201);
        Tlv tlv = tlvChain.getLastTlv(202);
        this.creation = tlv == null ? null : ((l = tlv.getDataAsUInt()) == -1L || l == 0L ? null : new Date(l * 1000L));
        this.maxMsgLen = tlvChain.getUShort(209);
        this.maxOccupancy = tlvChain.getUShort(210);
        this.name = tlvChain.getString(211);
        Tlv tlv2 = tlvChain.getLastTlv(213);
        this.createPerms = tlv2 == null ? (short)-1 : BinaryTools.getUByte(tlv2.getData(), 0);
        this.charset1 = tlvChain.getString(214);
        this.language1 = tlvChain.getString(215);
        this.charset2 = tlvChain.getString(216);
        this.language2 = tlvChain.getString(217);
        this.contentType = tlvChain.getString(219);
        this.something = tlvChain.getUShort(218);
    }

    private final synchronized void ensureTlvChainExists() {
        if (this.tlvChain != null) {
            return;
        }
        this.tlvChain = TlvTools.createMutableChain();
        if (this.flags != -1) {
            this.tlvChain.addTlv(Tlv.getUShortInstance(201, this.flags));
        }
        if (this.creation != null) {
            this.tlvChain.addTlv(Tlv.getUIntInstance(202, this.creation.getTime() / 1000L));
        }
        if (this.maxMsgLen != -1) {
            this.tlvChain.addTlv(Tlv.getUShortInstance(209, this.maxMsgLen));
        }
        if (this.maxOccupancy != -1) {
            this.tlvChain.addTlv(Tlv.getUShortInstance(210, this.maxOccupancy));
        }
        if (this.name != null) {
            this.tlvChain.addTlv(Tlv.getStringInstance(211, this.name));
        }
        if (this.createPerms != -1) {
            this.tlvChain.addTlv(new Tlv(213, ByteBlock.wrap(BinaryTools.getUByte(this.createPerms))));
        }
        if (this.charset1 != null) {
            this.tlvChain.addTlv(Tlv.getStringInstance(214, this.charset1));
        }
        if (this.language1 != null) {
            this.tlvChain.addTlv(Tlv.getStringInstance(215, this.language1));
        }
        if (this.charset2 != null) {
            this.tlvChain.addTlv(Tlv.getStringInstance(216, this.charset2));
        }
        if (this.language2 != null) {
            this.tlvChain.addTlv(Tlv.getStringInstance(217, this.language2));
        }
        if (this.contentType != null) {
            this.tlvChain.addTlv(Tlv.getStringInstance(219, this.contentType));
        }
        if (this.something != -1) {
            this.tlvChain.addTlv(Tlv.getUShortInstance(218, this.something));
        }
    }

    protected final synchronized int getBaseTlvCount() {
        this.ensureTlvChainExists();
        return this.tlvChain.getTlvCount();
    }

    protected final synchronized void writeBaseInfo(OutputStream outputStream) throws IOException {
        this.ensureTlvChainExists();
        this.tlvChain.write(outputStream);
    }

    public final synchronized int getFlags() {
        return this.flags;
    }

    public final synchronized Date getCreationDate() {
        return this.creation;
    }

    public final synchronized int getMaxMsgLen() {
        return this.maxMsgLen;
    }

    public final synchronized int getMaxOccupancy() {
        return this.maxOccupancy;
    }

    public final synchronized String getName() {
        return this.name;
    }

    public final synchronized short getCreatePerms() {
        return this.createPerms;
    }

    public final synchronized String getCharset1() {
        return this.charset1;
    }

    public final synchronized String getLanguage1() {
        return this.language1;
    }

    public final synchronized String getCharset2() {
        return this.charset2;
    }

    public final synchronized String getLanguage2() {
        return this.language2;
    }

    public final synchronized String getContentType() {
        return this.contentType;
    }

    public final synchronized int getSomething() {
        return this.something;
    }

    public synchronized String toString() {
        return MiscTools.getClassName(this) + ": " + "flags=" + this.flags + ", creation=" + this.creation + ", maxMsgLen=" + this.maxMsgLen + ", maxOccupancy=" + this.maxOccupancy + ", name='" + this.name + "'" + ", createPerms=" + this.createPerms + ", charset1='" + this.charset1 + "'" + ", charset2='" + this.charset2 + "'" + ", language1='" + this.language1 + "'" + ", language2='" + this.language2 + "'" + ", contentType='" + this.contentType + "'" + ", something=" + this.something;
    }
}

