/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class CloseFlapCmd
extends FlapCommand {
    public static final int CHANNEL_CLOSE = 4;
    public static final int CODE_LOGGED_IN_ELSEWHERE = 1;
    private static final int TYPE_CODE = 9;
    private static final int TYPE_URL = 11;
    private final int code;
    private final String url;

    protected CloseFlapCmd(FlapPacket flapPacket) {
        super(4);
        DefensiveTools.checkNull(flapPacket, "packet");
        ByteBlock byteBlock = flapPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        this.code = immutableTlvChain.getUShort(9);
        this.url = immutableTlvChain.getString(11);
    }

    public CloseFlapCmd() {
        this(-1, null);
    }

    public CloseFlapCmd(int n) {
        this(n, null);
    }

    public CloseFlapCmd(int n, String string) {
        super(4);
        DefensiveTools.checkRange(n, "code", -1);
        this.code = n;
        this.url = string;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getUrl() {
        return this.url;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.code != -1) {
            Tlv.getUShortInstance(9, this.code).write(outputStream);
        }
        if (this.url != null) {
            Tlv.getStringInstance(11, this.url).write(outputStream);
        }
    }

    public String toString() {
        return "CloseFlapCmd: code=0x" + Integer.toHexString(this.code) + ", url=" + this.url;
    }
}

