/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import java.util.Hashtable;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.net.SocketFactory;
import org.jivesoftware.whack.ExternalComponent;
import org.jivesoftware.whack.container.ServerContainer;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.component.Log;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class ExternalComponentManager
implements ComponentManager {
    private String host;
    private int port;
    private String defaultSecretKey;
    private Map<String, String> secretKeys = new Hashtable<String, String>();
    Preferences preferences = Preferences.userRoot();
    private String preferencesPrefix;
    private Map<String, ExternalComponent> componentsByDomain = new Hashtable<String, ExternalComponent>();
    private Map<Component, ExternalComponent> components = new Hashtable<Component, ExternalComponent>();
    private Log logger;

    public ExternalComponentManager(String host) {
        this(host, 5222);
    }

    public ExternalComponentManager(String host, int port) {
        this.host = host;
        this.port = port;
        this.preferencesPrefix = "whack." + host + ".";
        this.createDummyLogger();
        ComponentManagerFactory.setComponentManager(this);
    }

    public void setSecretKey(String subdomain, String secretKey) {
        this.secretKeys.put(subdomain, secretKey);
    }

    public String getSecretKey(String subdomain) {
        String secretKey = this.secretKeys.get(subdomain);
        if (secretKey == null) {
            secretKey = this.defaultSecretKey;
        }
        return secretKey;
    }

    public void setDefaultSecretKey(String secretKey) {
        this.defaultSecretKey = secretKey;
    }

    public void addComponent(String subdomain, Component component) throws ComponentException {
        if (this.componentsByDomain.containsKey(subdomain)) {
            if (this.componentsByDomain.get(subdomain).getComponent() == component) {
                return;
            }
            throw new IllegalArgumentException("Subdomain already in use by another component");
        }
        String secretKey = this.secretKeys.get(subdomain);
        if (secretKey == null) {
            secretKey = this.defaultSecretKey;
        }
        ExternalComponent externalComponent = new ExternalComponent(component, this);
        try {
            this.componentsByDomain.put(subdomain, externalComponent);
            this.components.put(component, externalComponent);
            externalComponent.connect(this.host, this.port, SocketFactory.getDefault(), subdomain);
            JID componentJID = new JID(null, externalComponent.getDomain(), null);
            externalComponent.initialize(componentJID, this);
        }
        catch (ComponentException e) {
            this.componentsByDomain.remove(subdomain);
            this.components.remove(component);
            throw e;
        }
        externalComponent.start();
    }

    public void removeComponent(String subdomain) throws ComponentException {
        ExternalComponent externalComponent = this.componentsByDomain.remove(subdomain);
        this.components.remove(externalComponent.getComponent());
        if (externalComponent != null) {
            externalComponent.shutdown();
        }
    }

    public void sendPacket(Component component, Packet packet) {
        this.components.get(component).send(packet);
    }

    public String getProperty(String name) {
        return this.preferences.get(this.preferencesPrefix + name, null);
    }

    public void setProperty(String name, String value) {
        this.preferences.put(this.preferencesPrefix + name, value);
    }

    public String getServerName() {
        return this.host;
    }

    public boolean isExternalMode() {
        return true;
    }

    public String getHomeDirectory() {
        return ServerContainer.getInstance().getHomeDirectory();
    }

    public Log getLog() {
        return this.logger;
    }

    private void createDummyLogger() {
        this.logger = new Log(){

            public void error(String message) {
                System.out.println(message);
            }

            public void error(String message, Throwable throwable) {
                System.err.println(message);
                throwable.printStackTrace();
            }

            public void error(Throwable throwable) {
                throwable.printStackTrace();
            }

            public void warn(String message) {
                System.out.println(message);
            }

            public void warn(String message, Throwable throwable) {
                System.out.println(message);
                throwable.printStackTrace();
            }

            public void warn(Throwable throwable) {
                throwable.printStackTrace();
            }

            public void info(String message) {
                System.out.println(message);
            }

            public void info(String message, Throwable throwable) {
                System.out.println(message);
                throwable.printStackTrace();
            }

            public void info(Throwable throwable) {
                throwable.printStackTrace();
            }

            public void debug(String message) {
                System.out.println(message);
            }

            public void debug(String message, Throwable throwable) {
                System.out.println(message);
                throwable.printStackTrace();
            }

            public void debug(Throwable throwable) {
                throwable.printStackTrace();
            }
        };
    }
}

