/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeAdapter;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.util.Logger;

public abstract class ActiveCallsRepository<T extends Call, U extends OperationSetBasicTelephony<? extends ProtocolProviderService>>
extends CallChangeAdapter {
    private static final Logger logger = Logger.getLogger(ActiveCallsRepository.class);
    private final Hashtable<String, T> activeCalls = new Hashtable();
    protected final U parentOperationSet;

    public ActiveCallsRepository(U opSet) {
        this.parentOperationSet = opSet;
    }

    public void addCall(T call) {
        this.activeCalls.put(((Call)call).getCallID(), call);
        ((Call)call).addCallChangeListener(this);
    }

    @Override
    public void callStateChanged(CallChangeEvent evt) {
        if (evt.getEventType().equals("CallState") && evt.getNewValue().equals(CallState.CALL_ENDED)) {
            Call sourceCall = (Call)this.activeCalls.remove(evt.getSourceCall().getCallID());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Removing call " + sourceCall + " from the list of active calls" + " because it entered an ENDED state"));
            }
            this.fireCallEvent(3, sourceCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<T> getActiveCalls() {
        Hashtable<String, T> hashtable = this.activeCalls;
        synchronized (hashtable) {
            return new ArrayList<T>(this.activeCalls.values()).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCallCount() {
        Hashtable<String, T> hashtable = this.activeCalls;
        synchronized (hashtable) {
            return this.activeCalls.size();
        }
    }

    protected void fireCallEvent(int eventID, Call sourceCall) {
        this.fireCallEvent(eventID, sourceCall, null);
    }

    protected abstract void fireCallEvent(int var1, Call var2, CallChangeEvent var3);
}

