/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.util.BlobBuffer;

public class BlobImpl
implements Blob {
    private static final byte[] EMPTY_BLOB = new byte[0];
    private final BlobBuffer blobBuffer;

    BlobImpl(ConnectionJDBC2 connection) {
        this(connection, EMPTY_BLOB);
    }

    BlobImpl(ConnectionJDBC2 connection, byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null");
        }
        this.blobBuffer = new BlobBuffer(connection.getBufferDir(), connection.getLobBuffer());
        this.blobBuffer.setBuffer(bytes, false);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.blobBuffer.getBinaryStream(false);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.blobBuffer.getBytes(pos, length);
    }

    public long length() throws SQLException {
        return this.blobBuffer.getLength();
    }

    public long position(byte[] pattern, long start) throws SQLException {
        return this.blobBuffer.position(pattern, start);
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            throw new SQLException(Messages.get("error.blob.badpattern"), "HY009");
        }
        return this.blobBuffer.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        return this.blobBuffer.setBinaryStream(pos, false);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw new SQLException(Messages.get("error.blob.bytesnull"), "HY009");
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (bytes == null) {
            throw new SQLException(Messages.get("error.blob.bytesnull"), "HY009");
        }
        return this.blobBuffer.setBytes(pos, bytes, offset, len, true);
    }

    public void truncate(long len) throws SQLException {
        this.blobBuffer.truncate(len);
    }
}

