/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MetaDataUtils {
    public static Map parseMetaData(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        if (eventType == 2 && parser.getName().equals("metadata") && parser.getNamespace().equals("http://jivesoftware.com/protocol/workgroup")) {
            Hashtable metaData = new Hashtable();
            eventType = parser.nextTag();
            while (eventType != 3 || !parser.getName().equals("metadata")) {
                List<String> values;
                String name = parser.getAttributeValue(0);
                String value = parser.nextText();
                if (metaData.containsKey(name)) {
                    values = (List)metaData.get(name);
                    values.add(value);
                } else {
                    values = new ArrayList();
                    values.add(value);
                    metaData.put(name, values);
                }
                eventType = parser.nextTag();
            }
            return metaData;
        }
        return Collections.EMPTY_MAP;
    }

    public static String serializeMetaData(Map metaData) {
        StringBuilder buf = new StringBuilder();
        if (metaData != null && metaData.size() > 0) {
            buf.append("<metadata xmlns=\"http://jivesoftware.com/protocol/workgroup\">");
            for (Object key : metaData.keySet()) {
                Object value = metaData.get(key);
                if (value instanceof List) {
                    List values = (List)metaData.get(key);
                    for (String v : values) {
                        buf.append("<value name=\"").append(key).append("\">");
                        buf.append(StringUtils.escapeForXML(v));
                        buf.append("</value>");
                    }
                    continue;
                }
                if (!(value instanceof String)) continue;
                buf.append("<value name=\"").append(key).append("\">");
                buf.append(StringUtils.escapeForXML((String)value));
                buf.append("</value>");
            }
            buf.append("</metadata>");
        }
        return buf.toString();
    }
}

