/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.utils.Exceptions;
import com.voxeo.utils.IO;
import com.voxeo.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String log4jConfiguration = servletContext.getInitParameter("log4jConfigLocation");
        if (log4jConfiguration == null) {
            throw new IllegalArgumentException("log4j configuration file cannot be null");
        }
        File file = new File(log4jConfiguration = Strings.replaceProperties(log4jConfiguration));
        if (!file.exists()) {
            Exceptions.fling(IllegalArgumentException.class, "log4j configuration file does not exist [file=%s]", log4jConfiguration);
        }
        String xml = null;
        try {
            xml = IO.getContentsAsString(file);
        }
        catch (IOException e) {
            Exceptions.fling(IllegalStateException.class, "Failed to read log4j configuration [file=%s]", log4jConfiguration);
        }
        Properties props = new Properties(System.getProperties());
        Enumeration parameterNames = servletContext.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            props.put(name, servletContext.getInitParameter(name));
        }
        xml = Strings.replaceProperties(xml, props);
        DOMConfigurator configurator = new DOMConfigurator();
        configurator.doConfigure((Reader)new StringReader(xml), LogManager.getLoggerRepository());
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

