/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrentlinkedhashmap;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.GuardedBy;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class RingBuffer<E>
extends AtomicReferenceArray<E> {
    private static final int RETRIES = 10;
    final AtomicLong head;
    final AtomicLong tail;
    final long threshold;
    final Sink<E> sink;
    final Lock lock;
    final int mask;

    public RingBuffer(int estimatedCapacity, int threshold, Sink<E> sink) {
        super(ConcurrentLinkedHashMap.ceilingNextPowerOfTwo(estimatedCapacity));
        this.sink = sink;
        this.mask = this.length() - 1;
        this.threshold = threshold;
        this.head = new AtomicLong();
        this.tail = new AtomicLong();
        this.lock = new ReentrantLock();
    }

    public boolean isEmpty() {
        return this.head.get() == this.tail.get();
    }

    public void put(E e) {
        long t = this.tail.getAndIncrement();
        int index = (int)(t & (long)this.mask);
        while (true) {
            for (int i = 0; i < 10; ++i) {
                if (this.get(index) != null || !this.weakCompareAndSet(index, null, e)) continue;
                if (t - this.head.get() >= this.threshold) {
                    this.tryToDrain();
                }
                return;
            }
            this.tryToDrain();
        }
    }

    @GuardedBy(value="lock")
    public E poll() {
        long h = this.head.get();
        if (h == this.tail.get()) {
            return null;
        }
        int index = (int)h & this.mask;
        Object e = this.get(index);
        this.lazySet(index, null);
        this.head.lazySet(h + 1L);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToDrain() {
        if (this.lock.tryLock()) {
            try {
                this.drain();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @GuardedBy(value="lock")
    public void drain() {
        int index;
        Object e;
        long t;
        long h = this.head.get();
        if (h == (t = this.tail.get())) {
            return;
        }
        while ((e = this.get(index = (int)(h & (long)this.mask))) != null) {
            this.lazySet(index, null);
            this.sink.accept(e);
            if (h++ != t) continue;
        }
        this.head.lazySet(h);
    }

    public static interface Sink<E> {
        public void accept(E var1);
    }
}

