/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.fmj.gui.controlpanel.SwingLookControlPanel;
import net.sf.fmj.ui.application.ContainerPlayerStatusListener;
import net.sf.fmj.utility.ClasspathChecker;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class ContainerPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private Container container;
    private volatile Player player;
    private Component visualComponent;
    private boolean shouldStartOnRealize = false;
    private volatile boolean autoLoop = false;
    private MouseListener mouseListener;
    private String mediaLocation;
    private ControllerListener controllerListener = new ControllerListener(){

        public void controllerUpdate(ControllerEvent controllerEvent) {
            logger.fine("Got controller event: " + controllerEvent);
            Player player = (Player)controllerEvent.getSourceController();
            if (player != ContainerPlayer.this.player) {
                return;
            }
            if (controllerEvent instanceof RealizeCompleteEvent) {
                ContainerPlayer.this.notifyStatusListener("Ready.");
                try {
                    ContainerPlayer.this.setVisualComponent(player.getVisualComponent());
                    if (ContainerPlayer.this.shouldStartOnRealize) {
                        ContainerPlayer.this.start();
                    }
                }
                catch (Exception exception) {
                    ContainerPlayer.this.notifyStatusListener("Error displaying player.");
                    logger.log(Level.WARNING, "" + exception, exception);
                    JLabel jLabel = new JLabel("");
                    ContainerPlayer.this.setVisualComponent(jLabel);
                }
            } else if (controllerEvent instanceof ResourceUnavailableEvent) {
                ContainerPlayer.this.notifyStatusListener("Error loading to media.");
                JLabel jLabel = new JLabel("");
                ContainerPlayer.this.setVisualComponent(jLabel);
            } else if (controllerEvent instanceof StopEvent) {
                ContainerPlayer.this.notifyStatusListener("Stopped.");
            } else if (controllerEvent instanceof StartEvent) {
                ContainerPlayer.this.notifyStatusListener("Playing...");
            } else if (controllerEvent instanceof ControllerErrorEvent) {
                ContainerPlayer.this.notifyStatusListener("Error: " + ((ControllerErrorEvent)controllerEvent).getMessage());
            } else if (controllerEvent instanceof ControllerClosedEvent) {
                // empty if block
            }
            if (controllerEvent instanceof EndOfMediaEvent) {
                ContainerPlayer.this.notifyStatusListener("End of media.");
                player.setMediaTime(new Time(0L));
                if (ContainerPlayer.this.autoLoop) {
                    ContainerPlayer.this.start();
                }
            }
        }
    };
    private ContainerPlayerStatusListener statusListener;
    private SwingLookControlPanel transportControlPanel;

    public ContainerPlayer(Container container) {
        this.setContainer(container);
    }

    public void close() {
        this.shouldStartOnRealize = false;
        if (this.player != null) {
            this.player.close();
        }
    }

    private void createNewPlayer(MediaLocator mediaLocator) throws NoPlayerException, IOException {
        String string;
        if (!ClasspathChecker.check() && mediaLocator.getProtocol().equals("file") && (string = URLUtils.createAbsoluteFileUrl(mediaLocator.toExternalForm())) != null) {
            MediaLocator mediaLocator2 = new MediaLocator(string);
            if (!mediaLocator.toExternalForm().equals(mediaLocator2.toExternalForm())) {
                logger.warning("Changing file URL to absolute for JMF, from " + mediaLocator.toExternalForm() + " to " + mediaLocator2);
                mediaLocator = mediaLocator2;
            }
        }
        this.player = Manager.createPlayer(mediaLocator);
        this.player.addControllerListener(this.controllerListener);
        this.getTransportControlPanel().setPlayer(this.player);
        this.player.realize();
    }

    public void deallocate() {
        this.shouldStartOnRealize = false;
        if (this.player != null) {
            this.player.deallocate();
            this.player = null;
        }
    }

    private Container getContainer() {
        return this.container;
    }

    private MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public SwingLookControlPanel getTransportControlPanel() {
        if (this.transportControlPanel == null) {
            this.transportControlPanel = new SwingLookControlPanel();
        }
        return this.transportControlPanel;
    }

    public boolean isAutoLoop() {
        return this.autoLoop;
    }

    private void notifyStatusListener(String string) {
        if (this.statusListener != null) {
            this.statusListener.onStatusChange(string);
        }
    }

    public void setAutoLoop(boolean bl) {
        this.autoLoop = bl;
    }

    private void setContainer(Container container) {
        this.container = container;
    }

    public void setContainerPlayerStatusListener(ContainerPlayerStatusListener containerPlayerStatusListener) {
        this.statusListener = containerPlayerStatusListener;
    }

    public void setGain(float f) {
        if (this.player != null && this.player.getGainControl() != null) {
            this.player.getGainControl().setLevel(f);
        }
    }

    public void setMediaLocation(String string, boolean bl) throws NoDataSourceException, NoPlayerException, IOException {
        logger.fine("setMediaLocation: " + string + " startAutomatically=" + bl);
        try {
            MediaLocator mediaLocator = new MediaLocator(string);
            this.stop();
            if (this.player != null) {
                this.player.close();
                this.player.deallocate();
                this.player = null;
            }
            this.notifyStatusListener("Loading...");
            if (bl) {
                this.shouldStartOnRealize = true;
            }
            this.createNewPlayer(mediaLocator);
        }
        catch (NoPlayerException noPlayerException) {
            this.notifyStatusListener("Error loading media.");
            throw noPlayerException;
        }
        catch (IOException iOException) {
            this.notifyStatusListener("Error loading media.");
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.notifyStatusListener("Error loading media.");
            throw runtimeException;
        }
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    public void setMute(boolean bl) {
        if (this.player != null && this.player.getGainControl() != null) {
            this.player.getGainControl().setMute(bl);
        }
    }

    public void setRealizedStartedProcessor(Processor processor) {
        this.stop();
        if (this.player != null) {
            this.player.close();
            this.player.deallocate();
            this.player = null;
        }
        this.notifyStatusListener("Processing...");
        this.useExistingRealizedStartedPlayer(processor);
    }

    private void setVisualComponent(final Component component) {
        if (this.visualComponent == component) {
            return;
        }
        if (this.getMouseListener() != null) {
            component.addMouseListener(this.getMouseListener());
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (ContainerPlayer.this.visualComponent != null) {
                    ContainerPlayer.this.getContainer().remove(ContainerPlayer.this.visualComponent);
                }
                ContainerPlayer.this.visualComponent = component;
                if (component != null) {
                    ContainerPlayer.this.getContainer().add(component);
                }
                ContainerPlayer.this.getContainer().validate();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void start() {
        if (this.player != null) {
            this.shouldStartOnRealize = false;
            this.player.start();
        } else {
            this.shouldStartOnRealize = true;
        }
    }

    public void stop() {
        this.shouldStartOnRealize = false;
        if (this.player != null) {
            this.player.stop();
        }
    }

    private void useExistingRealizedStartedPlayer(Player player) {
        this.player = player;
        this.player.addControllerListener(this.controllerListener);
        this.getTransportControlPanel().setPlayer(this.player);
    }
}

