/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import javax.media.Format;

class FormatTable {
    public Format[] keys;
    public Format[][] table;
    public int[] hits;
    public int last;

    public FormatTable(int n) {
        this.keys = new Format[n];
        this.table = new Format[n][];
        this.hits = new int[n];
        this.last = 0;
    }

    public int findLeastHit() {
        int n = this.hits[0];
        int n2 = 0;
        for (int i = 1; i < this.last; ++i) {
            if (this.hits[i] >= n) continue;
            n = this.hits[i];
            n2 = i;
        }
        return n2;
    }

    Format[] get(Format format) {
        Format[] formatArray = null;
        for (int i = 0; i < this.last; ++i) {
            if (formatArray == null && this.keys[i].matches(format)) {
                formatArray = this.table[i];
                this.hits[i] = this.keys.length;
                continue;
            }
            this.hits[i] = this.hits[i] - 1;
        }
        return formatArray;
    }

    public void save(Format format, Format[] formatArray) {
        int n = this.last >= this.keys.length ? this.findLeastHit() : this.last++;
        this.keys[n] = format;
        this.table[n] = formatArray;
        this.hits[n] = this.keys.length;
    }
}

