/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import javax.media.control.BufferControl;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.JitterBuffer;
import net.sf.fmj.media.rtp.JitterBufferBehaviour;
import net.sf.fmj.media.rtp.JitterBufferStats;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPSourceStream;

class BasicJitterBufferBehaviour
implements JitterBufferBehaviour {
    protected final JitterBuffer q;
    private int recvBufSize;
    protected final JitterBufferStats stats;
    protected final RTPSourceStream stream;

    protected BasicJitterBufferBehaviour(RTPSourceStream rTPSourceStream) {
        this.stream = rTPSourceStream;
        this.q = this.stream.q;
        this.stats = this.stream.stats;
    }

    protected void dropFirstPkt() {
        this.q.dropFirstFill();
    }

    public void dropPkt() {
        this.dropFirstPkt();
    }

    public int getAbsoluteMaximumDelay() {
        return this.getMaximumDelay();
    }

    protected BufferControl getBufferControl() {
        return this.stream.getBufferControl();
    }

    public int getMaximumDelay() {
        return 65535;
    }

    public int getNominalDelay() {
        return 0;
    }

    protected void grow(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("capacity");
        }
        int n2 = this.q.getCapacity();
        if (n == n2) {
            return;
        }
        if (n < n2) {
            throw new IllegalArgumentException("capacity");
        }
        Log.info("Growing packet queue to " + n);
        this.stats.incrementNbGrow();
        this.q.setCapacity(n);
    }

    public boolean isAdaptive() {
        return false;
    }

    protected int monitorQSize(Buffer buffer) {
        return 0;
    }

    public boolean preAdd(Buffer buffer, RTPRawReceiver rTPRawReceiver) {
        this.stats.updateSizePerPacket(buffer);
        int n = this.monitorQSize(buffer);
        if (n > 0) {
            this.setRecvBufSize(rTPRawReceiver, n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) {
        if (this.q.getFillCount() == 0) {
            buffer.setDiscard(true);
        } else {
            Buffer buffer2 = this.q.getFill();
            try {
                Object object = buffer.getData();
                Object object2 = buffer.getHeader();
                buffer.copy(buffer2);
                buffer2.setData(object);
                buffer2.setHeader(object2);
            }
            finally {
                this.q.returnFree(buffer2);
            }
        }
    }

    public void reset() {
    }

    protected void setRecvBufSize(RTPRawReceiver rTPRawReceiver, int n) {
        int n2 = this.stats.getSizePerPacket();
        int n3 = n * n2 / 2;
        if (rTPRawReceiver != null && n3 > this.recvBufSize) {
            rTPRawReceiver.setRecvBufSize(n3);
            int n4 = rTPRawReceiver.getRecvBufSize();
            this.recvBufSize = n4 < n3 ? Integer.MAX_VALUE : n3;
            Log.comment("RTP socket receive buffer size: " + n4 + " bytes.\n");
        }
    }

    public boolean willReadBlock() {
        return this.q.noMoreFill();
    }
}

