/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer.audio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.sf.fmj.media.multiplexer.AbstractStreamCopyMux;
import net.sf.fmj.media.multiplexer.StreamCopyPushDataSource;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class JavaSoundMux
extends AbstractStreamCopyMux {
    private static final Logger logger = LoggerSingleton.logger;
    private final AudioFileFormat.Type audioFileFormatType;
    private static final int MAX_TRACKS = 1;

    public JavaSoundMux(FileTypeDescriptor fileTypeDescriptor, AudioFileFormat.Type type) {
        super(fileTypeDescriptor);
        this.audioFileFormatType = type;
    }

    protected StreamCopyPushDataSource createInputStreamPushDataSource(ContentDescriptor contentDescriptor, int n, InputStream[] inputStreamArray, Format[] formatArray) {
        return new MyPushDataSource(contentDescriptor, n, inputStreamArray, formatArray);
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("LINEAR")};
    }

    public int setNumTracks(int n) {
        return super.setNumTracks(n > 1 ? 1 : n);
    }

    protected void write(InputStream inputStream, OutputStream outputStream, javax.sound.sampled.AudioFormat audioFormat) throws IOException {
        AudioInputStream audioInputStream = new AudioInputStream(inputStream, audioFormat, Integer.MAX_VALUE);
        AudioFileFormat.Type type = this.audioFileFormatType;
        int n = AudioSystem.write(audioInputStream, type, outputStream);
        logger.fine("Audio OutputStream bytes written: " + n);
    }

    private class MyPushDataSource
    extends StreamCopyPushDataSource {
        final javax.sound.sampled.AudioFormat[] javaSoundFormats;

        public MyPushDataSource(ContentDescriptor contentDescriptor, int n, InputStream[] inputStreamArray, Format[] formatArray) {
            super(contentDescriptor, n, inputStreamArray, formatArray);
            this.javaSoundFormats = new javax.sound.sampled.AudioFormat[n];
            for (int i = 0; i < n; ++i) {
                this.javaSoundFormats[i] = JavaSoundUtils.convertFormat((AudioFormat)formatArray[i]);
            }
        }

        protected void write(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
            JavaSoundMux.this.write(inputStream, outputStream, this.javaSoundFormats[n]);
        }
    }
}

