/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Control;
import javax.media.Format;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Renderer;
import javax.media.Track;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FrameRateControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.BasicModule;
import net.sf.fmj.media.BasicMuxModule;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.BasicRendererModule;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.Module;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.control.ProgressControl;
import net.sf.fmj.media.control.StringControl;

public class BasicTrackControl
implements TrackControl {
    static final String realizeErr = "Cannot get CodecControl before reaching the realized state.";
    static final String connectErr = "Cannot set a PlugIn before reaching the configured state.";
    PlaybackEngine engine;
    Track track;
    OutputConnector firstOC;
    OutputConnector lastOC;
    protected Vector modules = new Vector(7);
    protected BasicRendererModule rendererModule;
    protected BasicMuxModule muxModule = null;
    protected boolean prefetchFailed = false;
    protected boolean rendererFailed = false;
    float lastFrameRate = 0.0f;
    long lastStatsTime = 0L;

    public BasicTrackControl(PlaybackEngine playbackEngine, Track track, OutputConnector outputConnector) {
        this.engine = playbackEngine;
        this.track = track;
        this.firstOC = outputConnector;
        this.lastOC = outputConnector;
        this.setEnabled(track.isEnabled());
    }

    public boolean buildTrack(int n, int n2) {
        return false;
    }

    protected FrameRateControl frameRateControl() {
        return null;
    }

    public Object getControl(String string) {
        Class<?> clazz;
        try {
            clazz = BasicPlugIn.getClassForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object[] objectArray = this.getControls();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!clazz.isInstance(objectArray[i])) continue;
            return objectArray[i];
        }
        return null;
    }

    public Component getControlComponent() {
        return null;
    }

    public Object[] getControls() throws NotRealizedError {
        int n;
        InputConnector inputConnector;
        if (this.engine.getState() < 300) {
            throw new NotRealizedError(realizeErr);
        }
        OutputConnector outputConnector = this.firstOC;
        Object var4_2 = null;
        Vector<Object> vector = new Vector<Object>();
        while (outputConnector != null && (inputConnector = outputConnector.getInputConnector()) != null) {
            Module module = inputConnector.getModule();
            Object[] objectArray = module.getControls();
            if (objectArray != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    vector.addElement(objectArray[n]);
                }
            }
            outputConnector = module.getOutputConnector(null);
        }
        int n2 = vector.size();
        Object[] objectArray = new Control[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = (Control)vector.elementAt(n);
        }
        return objectArray;
    }

    public Format getFormat() {
        return this.track.getFormat();
    }

    public Format getOriginalFormat() {
        return this.track.getFormat();
    }

    public Format[] getSupportedFormats() {
        return new Format[]{this.track.getFormat()};
    }

    public boolean isCustomized() {
        return false;
    }

    public boolean isEnabled() {
        return this.track.isEnabled();
    }

    public boolean isTimeBase() {
        return false;
    }

    public boolean prefetchTrack() {
        for (int i = 0; i < this.modules.size(); ++i) {
            BasicModule basicModule = (BasicModule)this.modules.elementAt(i);
            if (basicModule.doPrefetch()) continue;
            this.setEnabled(false);
            this.prefetchFailed = true;
            if (basicModule instanceof BasicRendererModule) {
                this.rendererFailed = true;
            }
            return false;
        }
        if (this.prefetchFailed) {
            this.setEnabled(true);
            this.prefetchFailed = false;
            this.rendererFailed = false;
        }
        return true;
    }

    public void prError() {
        Log.error("  Unable to handle format: " + this.getOriginalFormat());
        Log.write("\n");
    }

    protected ProgressControl progressControl() {
        return null;
    }

    public void setCodecChain(Codec[] codecArray) throws NotConfiguredError, UnsupportedPlugInException {
        if (this.engine.getState() > 180) {
            throw new NotConfiguredError(connectErr);
        }
        if (codecArray.length < 1) {
            throw new UnsupportedPlugInException("No codec specified in the array.");
        }
    }

    public void setEnabled(boolean bl) {
        this.track.setEnabled(bl);
    }

    public Format setFormat(Format format) {
        if (format != null && format.matches(this.getFormat())) {
            return this.getFormat();
        }
        return null;
    }

    public void setRenderer(Renderer renderer) throws NotConfiguredError {
        if (this.engine.getState() > 180) {
            throw new NotConfiguredError(connectErr);
        }
    }

    public void startTrack() {
        for (int i = 0; i < this.modules.size(); ++i) {
            ((BasicModule)this.modules.elementAt(i)).doStart();
        }
    }

    public void stopTrack() {
        for (int i = 0; i < this.modules.size(); ++i) {
            ((BasicModule)this.modules.elementAt(i)).doStop();
        }
    }

    public void updateFormat() {
        StringControl stringControl;
        Object object;
        if (!this.track.isEnabled()) {
            return;
        }
        ProgressControl progressControl = this.progressControl();
        if (progressControl == null) {
            return;
        }
        if (this.track.getFormat() instanceof AudioFormat) {
            object = "";
            AudioFormat audioFormat = (AudioFormat)this.track.getFormat();
            stringControl = progressControl.getAudioCodec();
            stringControl.setValue(audioFormat.getEncoding());
            stringControl = progressControl.getAudioProperties();
            object = audioFormat.getChannels() == 1 ? "mono" : "stereo";
            stringControl.setValue(audioFormat.getSampleRate() / 1000.0 + " KHz, " + audioFormat.getSampleSizeInBits() + "-bit, " + (String)object);
        }
        if (this.track.getFormat() instanceof VideoFormat) {
            object = (VideoFormat)this.track.getFormat();
            stringControl = progressControl.getVideoCodec();
            stringControl.setValue(((Format)object).getEncoding());
            stringControl = progressControl.getVideoProperties();
            if (((VideoFormat)object).getSize() != null) {
                stringControl.setValue(((VideoFormat)object).getSize().width + " X " + ((VideoFormat)object).getSize().height);
            }
        }
    }

    public void updateRates(long l) {
        float f;
        FrameRateControl frameRateControl = this.frameRateControl();
        if (frameRateControl == null) {
            return;
        }
        if (!this.track.isEnabled() || !(this.track.getFormat() instanceof VideoFormat) || this.rendererModule == null && this.muxModule == null) {
            return;
        }
        if (l == this.lastStatsTime) {
            f = this.lastFrameRate;
        } else {
            int n = this.rendererModule != null ? this.rendererModule.getFramesPlayed() : this.muxModule.getFramesPlayed();
            f = (float)n / (float)(l - this.lastStatsTime) * 1000.0f;
        }
        float f2 = (float)((int)((this.lastFrameRate + f) / 2.0f * 10.0f)) / 10.0f;
        frameRateControl.setFrameRate(f2);
        this.lastFrameRate = f;
        this.lastStatsTime = l;
        if (this.rendererModule != null) {
            this.rendererModule.resetFramesPlayed();
        } else {
            this.muxModule.resetFramesPlayed();
        }
    }
}

