/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.mapreduce;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyPredicate;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.TopologyChangedStrategy;
import com.hazelcast.mapreduce.impl.AbstractJobTracker;
import com.hazelcast.mapreduce.impl.MapReduceService;
import com.hazelcast.mapreduce.impl.MapReduceUtil;
import com.hazelcast.mapreduce.impl.operation.KeyValueJobOperation;
import com.hazelcast.mapreduce.impl.operation.StartProcessingJobOperation;
import com.hazelcast.mapreduce.impl.task.TrackableJobFuture;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.NodeEngine;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public abstract class AbstractMapReduceTask<Parameters>
extends AbstractMessageTask<Parameters>
implements ExecutionCallback {
    public AbstractMapReduceTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() {
        TrackableJobFuture jobFuture;
        MapReduceService mapReduceService = (MapReduceService)this.getService("hz:impl:mapReduceService");
        NodeEngine nodeEngine = mapReduceService.getNodeEngine();
        String objectName = this.getDistributedObjectName();
        AbstractJobTracker jobTracker = (AbstractJobTracker)mapReduceService.createDistributedObject(objectName);
        if (jobTracker.registerTrackableJob(jobFuture = new TrackableJobFuture(objectName, this.getJobId(), jobTracker, nodeEngine, null))) {
            this.startSupervisionTask(jobTracker);
            jobFuture.andThen(this);
        }
    }

    protected abstract String getJobId();

    protected abstract int getChunkSize();

    protected abstract String getTopologyChangedStrategy();

    protected abstract KeyValueSource getKeyValueSource();

    protected abstract Mapper getMapper();

    protected abstract CombinerFactory getCombinerFactory();

    protected abstract ReducerFactory getReducerFactory();

    protected abstract Collection getKeys();

    protected abstract KeyPredicate getPredicate();

    private void startSupervisionTask(JobTracker jobTracker) {
        AbstractOperation operation;
        String topologyChangedStrategyStr;
        MapReduceService mapReduceService = (MapReduceService)this.getService("hz:impl:mapReduceService");
        JobTrackerConfig config = ((AbstractJobTracker)jobTracker).getJobTrackerConfig();
        boolean communicateStats = config.isCommunicateStats();
        int chunkSize = this.getChunkSize();
        if (chunkSize == -1) {
            chunkSize = config.getChunkSize();
        }
        TopologyChangedStrategy topologyChangedStrategy = (topologyChangedStrategyStr = this.getTopologyChangedStrategy()) == null ? config.getTopologyChangedStrategy() : TopologyChangedStrategy.valueOf(topologyChangedStrategyStr.toUpperCase(Locale.ENGLISH));
        ClusterService cs = this.nodeEngine.getClusterService();
        Collection<MemberImpl> members = cs.getMemberList();
        String name = this.getDistributedObjectName();
        String jobId = this.getJobId();
        KeyValueSource keyValueSource = this.getKeyValueSource();
        Mapper mapper = this.getMapper();
        CombinerFactory combinerFactory = this.getCombinerFactory();
        ReducerFactory reducerFactory = this.getReducerFactory();
        Collection keys = this.getKeys();
        ArrayList keyObjects = null;
        if (keys != null) {
            keyObjects = new ArrayList(keys.size());
            for (Object key : keys) {
                keyObjects.add(this.serializationService.toObject(key));
            }
        }
        KeyPredicate predicate = this.getPredicate();
        for (MemberImpl member : members) {
            operation = new KeyValueJobOperation(name, jobId, chunkSize, keyValueSource, mapper, combinerFactory, reducerFactory, communicateStats, topologyChangedStrategy);
            MapReduceUtil.executeOperation(operation, member.getAddress(), mapReduceService, this.nodeEngine);
        }
        for (MemberImpl member : members) {
            operation = new StartProcessingJobOperation(name, jobId, keyObjects, predicate);
            MapReduceUtil.executeOperation(operation, member.getAddress(), mapReduceService, this.nodeEngine);
        }
    }

    public void onResponse(Object response) {
        Map m = (Map)response;
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : m.entrySet()) {
            Object key = this.serializationService.toData(entry.getKey());
            Object value = this.serializationService.toData(entry.getValue());
            hashMap.put(key, value);
        }
        this.sendResponse(hashMap);
    }

    @Override
    public void onFailure(Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof ExecutionException) {
            throwable = throwable.getCause();
        }
        this.sendClientMessage(throwable);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapReduceService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

