/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LoadFile
extends Task {
    private File srcFile;
    private boolean failOnError;
    private String encoding;
    private String property;
    private final Vector filterChains;

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public final void setProperty(String string) {
        this.property = string;
    }

    public final void setSrcFile(File file) {
        this.srcFile = file;
    }

    public final void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() throws BuildException {
        if (this.srcFile == null) {
            throw new BuildException("source file not defined");
        }
        if (this.property == null) {
            throw new BuildException("output property not defined");
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Reader reader = null;
        this.log("loading " + this.srcFile + " into property " + this.property, 3);
        try {
            try {
                long l = this.srcFile.length();
                this.log("file size = " + l, 4);
                int n = (int)l;
                fileInputStream = new FileInputStream(this.srcFile);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                reader = this.encoding == null ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, this.encoding);
                String string = "";
                if (n != 0) {
                    ChainReaderHelper chainReaderHelper = new ChainReaderHelper();
                    chainReaderHelper.setBufferSize(n);
                    chainReaderHelper.setPrimaryReader(reader);
                    chainReaderHelper.setFilterChains(this.filterChains);
                    chainReaderHelper.setProject(this.getProject());
                    reader = chainReaderHelper.getAssembledReader();
                    string = chainReaderHelper.readFully(reader);
                }
                if (string != null && string.length() > 0) {
                    this.getProject().setNewProperty(this.property, string);
                    this.log("loaded " + string.length() + " characters", 3);
                    this.log(this.property + " := " + string, 4);
                }
            }
            catch (IOException iOException) {
                String string = "Unable to load file: " + iOException.toString();
                if (this.failOnError) {
                    throw new BuildException(string, iOException, this.getLocation());
                }
                this.log(string, 0);
            }
            catch (BuildException buildException) {
                if (this.failOnError) {
                    throw buildException;
                }
                this.log(buildException.getMessage(), 0);
            }
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_13 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fileInputStream == null) return;
        fileInputStream.close();
    }

    public final void addFilterChain(FilterChain filterChain) {
        this.filterChains.addElement(filterChain);
    }

    private final /* synthetic */ void this() {
        this.srcFile = null;
        this.failOnError = true;
        this.encoding = null;
        this.property = null;
        this.filterChains = new Vector();
    }

    public LoadFile() {
        this.this();
    }
}

