/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.net.URL;
import org.jdesktop.jdic.desktop.internal.BrowserService;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.impl.WinAPIWrapper;
import org.jdesktop.jdic.desktop.internal.impl.WinUtility;

public class WinBrowserService
implements BrowserService {
    private static final String IE_NAME_PATTERN = "iexplore";
    private static final String[] RESERVED_TARGET_NAMES = new String[]{"_top", "_self", "_parent"};

    private String convertTargetName(String string) {
        boolean bl = false;
        for (int i = 0; i < RESERVED_TARGET_NAMES.length; ++i) {
            if (!string.equals(RESERVED_TARGET_NAMES[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = string.charAt(string.length() - i - 1);
        }
        String string2 = new String(cArray);
        String string3 = string2 + "?" + string2 + "?" + string2;
        return string3;
    }

    public void show(URL uRL) throws LaunchFailedException {
        boolean bl = false;
        String string = WinUtility.getVerbCommand(uRL, "opennew");
        if (string != null) {
            bl = true;
        } else {
            string = WinUtility.getVerbCommand(uRL, "open");
        }
        if (string != null) {
            boolean bl2 = bl ? WinAPIWrapper.WinShellExecute(uRL.toString(), "opennew") : WinAPIWrapper.WinShellExecute(uRL.toString(), "open");
            if (!bl2) {
                throw new LaunchFailedException("Failed to launch the default browser");
            }
        } else {
            throw new LaunchFailedException("No default browser associated with this URL");
        }
    }

    public void show(URL uRL, String string) throws LaunchFailedException {
        String string2 = WinUtility.getVerbCommand(uRL, "open");
        if (string2.toLowerCase().indexOf(IE_NAME_PATTERN) == -1) {
            throw new LaunchFailedException("The default browser doesn't support targeting URL feature.");
        }
        boolean bl = WinAPIWrapper.WinBrowseURLInIE(uRL.toString(), this.convertTargetName(string));
        if (!bl) {
            throw new LaunchFailedException("Failed to invoke the default browser.");
        }
    }
}

