/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.DNSIncoming;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;

final class DNSOutgoing {
    private static Logger logger = Logger.getLogger(DNSOutgoing.class.toString());
    int id;
    int flags;
    private boolean multicast;
    private int numQuestions;
    private int numAnswers;
    private int numAuthorities;
    private int numAdditionals;
    private Hashtable names;
    byte[] data;
    int off;
    int len;
    private LinkedList authorativeAnswers = new LinkedList();

    DNSOutgoing(int flags) {
        this(flags, true);
    }

    DNSOutgoing(int flags, boolean multicast) {
        this.flags = flags;
        this.multicast = multicast;
        this.names = new Hashtable();
        this.data = new byte[1460];
        this.off = 12;
    }

    void addQuestion(DNSQuestion rec) throws IOException {
        if (this.numAnswers > 0 || this.numAuthorities > 0 || this.numAdditionals > 0) {
            throw new IllegalStateException("Questions must be added before answers");
        }
        ++this.numQuestions;
        this.writeQuestion(rec);
    }

    void addAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        if (this.numAuthorities > 0 || this.numAdditionals > 0) {
            throw new IllegalStateException("Answers must be added before authorities and additionals");
        }
        if (!rec.suppressedBy(in)) {
            this.addAnswer(rec, 0L);
        }
    }

    void addAdditionalAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        if (this.off < 1260 && !rec.suppressedBy(in)) {
            this.writeRecord(rec, 0L);
            ++this.numAdditionals;
        }
    }

    void addAnswer(DNSRecord rec, long now) throws IOException {
        if (this.numAuthorities > 0 || this.numAdditionals > 0) {
            throw new IllegalStateException("Questions must be added before answers");
        }
        if (!(rec == null || now != 0L && rec.isExpired(now))) {
            this.writeRecord(rec, now);
            ++this.numAnswers;
        }
    }

    void addAuthorativeAnswer(DNSRecord rec) throws IOException {
        if (this.numAdditionals > 0) {
            throw new IllegalStateException("Authorative answers must be added before additional answers");
        }
        this.authorativeAnswers.add(rec);
        this.writeRecord(rec, 0L);
        ++this.numAuthorities;
    }

    void writeByte(int value) throws IOException {
        if (this.off >= this.data.length) {
            throw new IOException("buffer full");
        }
        this.data[this.off++] = (byte)value;
    }

    void writeBytes(String str, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.writeByte(str.charAt(off + i));
        }
    }

    void writeBytes(byte[] data) throws IOException {
        if (data != null) {
            this.writeBytes(data, 0, data.length);
        }
    }

    void writeBytes(byte[] data, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.writeByte(data[off + i]);
        }
    }

    void writeShort(int value) throws IOException {
        this.writeByte(value >> 8);
        this.writeByte(value);
    }

    void writeInt(int value) throws IOException {
        this.writeShort(value >> 16);
        this.writeShort(value);
    }

    void writeUTF(String str, int off, int len) throws IOException {
        char ch;
        int i;
        int utflen = 0;
        for (i = 0; i < len; ++i) {
            ch = str.charAt(off + i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                ++utflen;
                continue;
            }
            if (ch > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.writeByte(utflen);
        for (i = 0; i < len; ++i) {
            ch = str.charAt(off + i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                this.writeByte(ch);
                continue;
            }
            if (ch > '\u07ff') {
                this.writeByte(0xE0 | ch >> 12 & 0xF);
                this.writeByte(0x80 | ch >> 6 & 0x3F);
                this.writeByte(0x80 | ch >> 0 & 0x3F);
                continue;
            }
            this.writeByte(0xC0 | ch >> 6 & 0x1F);
            this.writeByte(0x80 | ch >> 0 & 0x3F);
        }
    }

    void writeName(String name) throws IOException {
        while (true) {
            int n;
            if ((n = name.indexOf(46)) < 0) {
                n = name.length();
            }
            if (n <= 0) {
                this.writeByte(0);
                return;
            }
            Integer offset = (Integer)this.names.get(name);
            if (offset != null) {
                int val = offset;
                if (val > this.off) {
                    logger.log(Level.WARNING, "DNSOutgoing writeName failed val=" + val + " name=" + name);
                }
                this.writeByte(val >> 8 | 0xC0);
                this.writeByte(val);
                return;
            }
            this.names.put(name, new Integer(this.off));
            this.writeUTF(name, 0, n);
            if (!(name = name.substring(n)).startsWith(".")) continue;
            name = name.substring(1);
        }
    }

    void writeQuestion(DNSQuestion question) throws IOException {
        this.writeName(question.name);
        this.writeShort(question.type);
        this.writeShort(question.clazz);
    }

    void writeRecord(DNSRecord rec, long now) throws IOException {
        int save = this.off;
        try {
            this.writeName(rec.name);
            this.writeShort(rec.type);
            this.writeShort(rec.clazz | (rec.unique && this.multicast ? 32768 : 0));
            this.writeInt(now == 0L ? rec.ttl : rec.getRemainingTTL(now));
            this.writeShort(0);
            int start = this.off;
            rec.write(this);
            int len = this.off - start;
            this.data[start - 2] = (byte)(len >> 8);
            this.data[start - 1] = (byte)(len & 0xFF);
        }
        catch (IOException e) {
            this.off = save;
            throw e;
        }
    }

    void finish() throws IOException {
        int save = this.off;
        this.off = 0;
        this.writeShort(this.multicast ? 0 : this.id);
        this.writeShort(this.flags);
        this.writeShort(this.numQuestions);
        this.writeShort(this.numAnswers);
        this.writeShort(this.numAuthorities);
        this.writeShort(this.numAdditionals);
        this.off = save;
    }

    boolean isQuery() {
        return (this.flags & 0x8000) == 0;
    }

    public boolean isEmpty() {
        return this.numQuestions == 0 && this.numAuthorities == 0 && this.numAdditionals == 0 && this.numAnswers == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.isQuery() ? "dns[query," : "dns[response,");
        buf.append(':');
        buf.append(",id=0x");
        buf.append(Integer.toHexString(this.id));
        if (this.flags != 0) {
            buf.append(",flags=0x");
            buf.append(Integer.toHexString(this.flags));
            if ((this.flags & 0x8000) != 0) {
                buf.append(":r");
            }
            if ((this.flags & 0x400) != 0) {
                buf.append(":aa");
            }
            if ((this.flags & 0x200) != 0) {
                buf.append(":tc");
            }
        }
        if (this.numQuestions > 0) {
            buf.append(",questions=");
            buf.append(this.numQuestions);
        }
        if (this.numAnswers > 0) {
            buf.append(",answers=");
            buf.append(this.numAnswers);
        }
        if (this.numAuthorities > 0) {
            buf.append(",authorities=");
            buf.append(this.numAuthorities);
        }
        if (this.numAdditionals > 0) {
            buf.append(",additionals=");
            buf.append(this.numAdditionals);
        }
        buf.append(",\nnames=" + this.names);
        buf.append(",\nauthorativeAnswers=" + this.authorativeAnswers);
        buf.append("]");
        return buf.toString();
    }
}

