/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.jitsi.util.Logger;

public class OsStatistics {
    private static OsStatistics instance = null;
    private static final Logger logger = Logger.getLogger(OsStatistics.class);
    private CPUInfo cpuInfo;
    private Method freeMemoryMethod = null;
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private Integer totalMemory = null;

    private static int convertBytesToMB(long bytes) {
        return (int)(bytes / 1000000L);
    }

    public static OsStatistics getOsStatistics() {
        if (instance == null) {
            instance = new OsStatistics();
        }
        return instance;
    }

    private OsStatistics() {
        this.cpuInfo = new CPUInfo();
    }

    public double getCPUUsage() {
        if (this.cpuInfo == null) {
            return -1.0;
        }
        try {
            return this.cpuInfo.getCPUUsage();
        }
        catch (Throwable e) {
            if (e instanceof UnsatisfiedLinkError) {
                this.cpuInfo = null;
            }
            logger.error((Object)"Failed to retrieve the cpu usage.", e);
            return -1.0;
        }
    }

    public int getTotalMemory() {
        if (this.totalMemory == null) {
            Method method;
            try {
                method = this.operatingSystemMXBean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            }
            catch (Exception e) {
                logger.error((Object)"The statistics of the size of the total memory is not available.");
                return -1;
            }
            method.setAccessible(true);
            Long totalMemoryBytes = 0L;
            try {
                totalMemoryBytes = (Long)method.invoke((Object)this.operatingSystemMXBean, new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)"The statistics of the size of the total memory is not available.");
                return -1;
            }
            this.totalMemory = OsStatistics.convertBytesToMB(totalMemoryBytes);
        }
        return this.totalMemory;
    }

    public int getUsedMemory() {
        if (this.totalMemory == null) {
            return -1;
        }
        if (this.freeMemoryMethod == null) {
            try {
                this.freeMemoryMethod = this.operatingSystemMXBean.getClass().getMethod("getFreePhysicalMemorySize", new Class[0]);
            }
            catch (Exception e) {
                logger.error((Object)"The statistics of the size of the used memory is not available.");
                return -1;
            }
            this.freeMemoryMethod.setAccessible(true);
        }
        int memoryInMB = -1;
        try {
            long memoryInBytes = (Long)this.freeMemoryMethod.invoke((Object)this.operatingSystemMXBean, new Object[0]);
            memoryInMB = this.totalMemory - OsStatistics.convertBytesToMB(memoryInBytes);
        }
        catch (Exception e) {
            logger.error((Object)"The statistics of the size of the used memory is not available.");
        }
        return memoryInMB;
    }

    private static class CPUInfo
    extends SigarCommandBase {
        private CPUInfo() {
        }

        public double getCPUUsage() throws SigarException {
            return this.sigar.getCpuPerc().getCombined();
        }

        public void output(String[] arg0) throws SigarException {
        }
    }
}

