/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.simulcast.messages;

import java.util.List;
import java.util.SortedSet;
import org.jitsi.videobridge.simulcast.SimulcastLayer;
import org.jitsi.videobridge.simulcast.messages.EndpointSimulcastLayer;
import org.jitsi.videobridge.simulcast.messages.NextSimulcastLayerStoppedEvent;
import org.jitsi.videobridge.simulcast.messages.SimulcastLayersChangedEvent;
import org.jitsi.videobridge.simulcast.messages.SimulcastLayersChangingEvent;
import org.jitsi.videobridge.simulcast.messages.StartSimulcastLayerCommand;
import org.jitsi.videobridge.simulcast.messages.StopSimulcastLayerCommand;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulcastMessagesMapper {
    public String toJson(StartSimulcastLayerCommand command) {
        if (command == null) {
            return "";
        }
        StringBuilder b = new StringBuilder("{\"colibriClass\":\"StartSimulcastLayerEvent\"");
        b.append(",\"simulcastLayer\":[");
        this.toJson(b, command.simulcastLayer);
        b.append("]}");
        return b.toString();
    }

    public String toJson(StopSimulcastLayerCommand command) {
        if (command == null) {
            return "";
        }
        StringBuilder b = new StringBuilder("{\"colibriClass\":\"StopSimulcastLayerEvent\"");
        b.append(",\"simulcastLayer\":[");
        this.toJson(b, command.simulcastLayer);
        b.append("]}");
        return b.toString();
    }

    public String toJson(SortedSet<SimulcastLayer> simulcastLayers) {
        if (simulcastLayers == null || simulcastLayers.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder("[");
        for (SimulcastLayer simulcastLayer : simulcastLayers) {
            this.toJson(b, simulcastLayer);
        }
        b.append("]");
        return b.toString();
    }

    public String toJson(SimulcastLayersChangingEvent event) {
        if (event == null) {
            return "";
        }
        StringBuilder b = new StringBuilder("{\"colibriClass\":\"SimulcastLayersChangingEvent\"");
        b.append(",\"endpointSimulcastLayers\":[");
        for (int i = 0; i < event.endpointSimulcastLayers.length; ++i) {
            this.toJson(b, event.endpointSimulcastLayers[i]);
            if (i == event.endpointSimulcastLayers.length - 1) continue;
            b.append(",");
        }
        b.append("]}");
        return b.toString();
    }

    public String toJson(NextSimulcastLayerStoppedEvent event) {
        if (event == null) {
            return "";
        }
        StringBuilder b = new StringBuilder("{\"colibriClass\":\"NextSimulcastLayerStoppedEvent\"");
        b.append(",\"endpointSimulcastLayers\":[");
        for (int i = 0; i < event.endpointSimulcastLayers.length; ++i) {
            this.toJson(b, event.endpointSimulcastLayers[i]);
            if (i == event.endpointSimulcastLayers.length - 1) continue;
            b.append(",");
        }
        b.append("]}");
        return b.toString();
    }

    public String toJson(SimulcastLayersChangedEvent event) {
        if (event == null) {
            return "";
        }
        StringBuilder b = new StringBuilder("{\"colibriClass\":\"SimulcastLayersChangedEvent\"");
        b.append(",\"endpointSimulcastLayers\":[");
        for (int i = 0; i < event.endpointSimulcastLayers.length; ++i) {
            this.toJson(b, event.endpointSimulcastLayers[i]);
            if (i == event.endpointSimulcastLayers.length - 1) continue;
            b.append(",");
        }
        b.append("]}");
        return b.toString();
    }

    private void toJson(StringBuilder b, EndpointSimulcastLayer endpointSimulcastLayer) {
        if (b == null || endpointSimulcastLayer == null) {
            return;
        }
        b.append("{\"endpoint\":");
        b.append(JSONValue.toJSONString((Object)endpointSimulcastLayer.endpoint));
        b.append(",\"simulcastLayer\":");
        this.toJson(b, endpointSimulcastLayer.simulcastLayer);
        b.append("}");
    }

    public void toJson(StringBuilder b, SimulcastLayer simulcastLayer) {
        if (b == null || simulcastLayer == null) {
            return;
        }
        b.append("{\"primarySSRC\":");
        b.append(Long.toString(simulcastLayer.getPrimarySSRC()));
        List<Long> associatedSSRCs = simulcastLayer.getAssociatedSSRCs();
        if (associatedSSRCs != null && associatedSSRCs.size() != 0) {
            b.append(",\"asociatedSSRCs\":[");
            for (int i = 0; i < associatedSSRCs.size(); ++i) {
                b.append(Long.toString(associatedSSRCs.get(i)));
                if (i == associatedSSRCs.size() - 1) continue;
                b.append(",");
            }
            b.append("]");
        }
        b.append("}");
    }
}

