/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

public class CircularByteArray {
    private final byte[] elements;
    private int tail;

    public CircularByteArray(int length) {
        this.elements = new byte[length];
        this.tail = 0;
    }

    public synchronized void push(byte element) {
        int tail = this.tail;
        this.elements[tail] = element;
        if (++tail >= this.elements.length) {
            tail = 0;
        }
        this.tail = tail;
    }

    public synchronized byte[] toArray() {
        byte[] array;
        byte[] elements = this.elements;
        if (elements == null) {
            array = null;
        } else {
            array = new byte[elements.length];
            int index = this.tail;
            for (int i = 0; i < elements.length; ++i) {
                array[i] = elements[index];
                if (++index < elements.length) continue;
                index = 0;
            }
        }
        return array;
    }
}

