/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icon.IconCommand;

public class UploadIconAck
extends IconCommand {
    public static final int CODE_DEFAULT = 0;
    public static final int CODE_SUCCESS = 1;
    public static final int CODE_TOO_LARGE = 4;
    public static final int CODE_BAD_FORMAT = 5;
    private final int code;
    private final ExtraInfoBlock iconInfo;

    protected UploadIconAck(SnacPacket packet) {
        super(3);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUByte((ByteBlock)snacData, (int)0);
        ByteBlock iconBlock = snacData.subBlock(1);
        this.iconInfo = ExtraInfoBlock.readExtraInfoBlock(iconBlock);
    }

    public UploadIconAck(ExtraInfoBlock iconInfo) {
        this(0, iconInfo);
    }

    public UploadIconAck(int code, ExtraInfoBlock iconInfo) {
        super(3);
        DefensiveTools.checkRange((int)code, (String)"code", (int)0);
        this.code = code;
        this.iconInfo = iconInfo;
    }

    public final int getCode() {
        return this.code;
    }

    public final ExtraInfoBlock getIconInfo() {
        return this.iconInfo;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUByte((OutputStream)out, (int)this.code);
        if (this.iconInfo != null) {
            this.iconInfo.write(out);
        }
    }

    public String toString() {
        return "UploadIconAck: code=" + this.code + ", iconInfo=<" + this.iconInfo + ">";
    }
}

