/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.nio.Address;
import com.hazelcast.util.ValidationUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;

public class PartitionInfo {
    private final Address[] addresses;
    private final int partitionId;

    public PartitionInfo(int partitionId, Address[] addresses) {
        this.addresses = ValidationUtil.isNotNull(addresses, "addresses");
        this.partitionId = partitionId;
    }

    public Address getReplicaAddress(int index) {
        return this.addresses[index];
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public Address[] getReplicaAddresses() {
        return this.addresses;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getReplicaCount() {
        return this.addresses.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfo that = (PartitionInfo)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        return Arrays.equals(this.addresses, that.addresses);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.addresses);
        result = 31 * result + this.partitionId;
        return result;
    }

    public String toString() {
        return "PartitionInfo{addresses=" + Arrays.toString(this.addresses) + ", partitionId=" + this.partitionId + '}';
    }
}

