/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.TypeUtil;

public class JSON {
    private JSON() {
    }

    public static String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        JSON.append(buffer, object);
        return buffer.toString();
    }

    public static String toString(Map object) {
        StringBuffer buffer = new StringBuffer();
        JSON.appendMap(buffer, object);
        return buffer.toString();
    }

    public static String toString(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        JSON.appendArray(buffer, array);
        return buffer.toString();
    }

    public static Object parse(String s, boolean stripOuterComment) {
        return JSON.parse(new Source(s), stripOuterComment);
    }

    public static Object parse(InputStream in, boolean stripOuterComment) throws IOException {
        String s = IO.toString(in);
        return JSON.parse(new Source(s), stripOuterComment);
    }

    public static Object parse(String s) {
        return JSON.parse(new Source(s), false);
    }

    public static Object parse(InputStream in) throws IOException {
        String s = IO.toString(in);
        return JSON.parse(new Source(s), false);
    }

    public static void append(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("null");
        } else if (object instanceof Generator) {
            JSON.appendJSON(buffer, (Generator)object);
        } else if (object instanceof Map) {
            JSON.appendMap(buffer, (Map)object);
        } else if (object instanceof List) {
            JSON.appendArray(buffer, LazyList.toArray(object, Object.class));
        } else if (object.getClass().isArray()) {
            JSON.appendArray(buffer, object);
        } else if (object instanceof Number) {
            JSON.appendNumber(buffer, (Number)object);
        } else if (object instanceof Boolean) {
            JSON.appendBoolean(buffer, (Boolean)object);
        } else if (object instanceof String) {
            JSON.appendString(buffer, (String)object);
        } else {
            JSON.appendString(buffer, object.toString());
        }
    }

    private static void appendNull(StringBuffer buffer) {
        buffer.append("null");
    }

    private static void appendJSON(StringBuffer buffer, Generator generator) {
        generator.addJSON(buffer);
    }

    private static void appendMap(StringBuffer buffer, Map object) {
        if (object == null) {
            JSON.appendNull(buffer);
            return;
        }
        buffer.append('{');
        Iterator iter = object.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            QuotedStringTokenizer.quote(buffer, entry.getKey().toString());
            buffer.append(':');
            JSON.append(buffer, entry.getValue());
            if (!iter.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append('}');
    }

    private static void appendArray(StringBuffer buffer, Object array) {
        if (array == null) {
            JSON.appendNull(buffer);
            return;
        }
        buffer.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            JSON.append(buffer, Array.get(array, i));
        }
        buffer.append(']');
    }

    private static void appendBoolean(StringBuffer buffer, Boolean b) {
        if (b == null) {
            JSON.appendNull(buffer);
            return;
        }
        buffer.append(b != false ? "true" : "false");
    }

    private static void appendNumber(StringBuffer buffer, Number number) {
        if (number == null) {
            JSON.appendNull(buffer);
            return;
        }
        buffer.append(number);
    }

    private static void appendString(StringBuffer buffer, String string) {
        if (string == null) {
            JSON.appendNull(buffer);
            return;
        }
        QuotedStringTokenizer.quote(buffer, string);
    }

    private static Object parse(Source source, boolean stripOuterComment) {
        int strip_state;
        int comment_state = 0;
        int n = strip_state = stripOuterComment ? 1 : 0;
        while (source.hasNext()) {
            char c = source.peek();
            if (comment_state == 1) {
                switch (c) {
                    case '/': {
                        comment_state = -1;
                        break;
                    }
                    case '*': {
                        comment_state = 2;
                        if (strip_state != true) break;
                        comment_state = 0;
                        strip_state = 2;
                    }
                }
            } else if (comment_state > 1) {
                switch (c) {
                    case '*': {
                        comment_state = 3;
                        break;
                    }
                    case '/': {
                        if (comment_state == 3) {
                            comment_state = 0;
                            break;
                        }
                        comment_state = 2;
                        break;
                    }
                    default: {
                        comment_state = 2;
                        break;
                    }
                }
            } else if (comment_state < 0) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        comment_state = 0;
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '{': {
                        return JSON.parseObject(source);
                    }
                    case '[': {
                        return JSON.parseArray(source);
                    }
                    case '\"': {
                        return JSON.parseString(source);
                    }
                    case '-': {
                        return JSON.parseNumber(source);
                    }
                    case 'n': {
                        JSON.complete("null", source);
                        return null;
                    }
                    case 't': {
                        JSON.complete("true", source);
                        return Boolean.TRUE;
                    }
                    case 'f': {
                        JSON.complete("false", source);
                        return Boolean.FALSE;
                    }
                    case 'u': {
                        JSON.complete("undefined", source);
                        return null;
                    }
                    case '/': {
                        comment_state = 1;
                        break;
                    }
                    case '*': {
                        if (strip_state == 2) {
                            JSON.complete("*/", source);
                            strip_state = 0;
                        }
                        return null;
                    }
                    default: {
                        if (Character.isDigit(c)) {
                            return JSON.parseNumber(source);
                        }
                        if (Character.isWhitespace(c)) break;
                        throw new IllegalStateException("unknown char " + c);
                    }
                }
            }
            source.next();
        }
        return null;
    }

    private static Map parseObject(Source source) {
        if (source.next() != '{') {
            throw new IllegalStateException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        char next = JSON.seekTo("\"}", source);
        while (source.hasNext()) {
            if (next == '}') {
                source.next();
                break;
            }
            String name = JSON.parseString(source);
            JSON.seekTo(':', source);
            source.next();
            Object value = JSON.parse(source, false);
            map.put(name, value);
            JSON.seekTo(",}", source);
            next = source.next();
            if (next == '}') break;
            next = JSON.seekTo("\"}", source);
        }
        return map;
    }

    private static Object parseArray(Source source) {
        if (source.next() != '[') {
            throw new IllegalStateException();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean coma = true;
        while (source.hasNext()) {
            char c = source.peek();
            switch (c) {
                case ']': {
                    source.next();
                    return list.toArray(new Object[list.size()]);
                }
                case ',': {
                    if (coma) {
                        throw new IllegalStateException();
                    }
                    coma = true;
                    source.next();
                }
            }
            if (Character.isWhitespace(c)) {
                source.next();
                continue;
            }
            coma = false;
            list.add(JSON.parse(source, false));
        }
        throw new IllegalStateException("unexpected end of array");
    }

    private static String parseString(Source source) {
        if (source.next() != '\"') {
            throw new IllegalStateException();
        }
        boolean escape = false;
        StringBuffer b = new StringBuffer();
        block8: while (source.hasNext()) {
            char c = source.next();
            if (escape) {
                escape = false;
                switch (c) {
                    case 'n': {
                        b.append('\n');
                        continue block8;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block8;
                    }
                    case 't': {
                        b.append('\t');
                        continue block8;
                    }
                    case 'f': {
                        b.append('\f');
                        continue block8;
                    }
                    case 'b': {
                        b.append('\b');
                        continue block8;
                    }
                    case 'u': {
                        b.append((char)((TypeUtil.convertHexDigit((byte)source.next()) << 24) + (TypeUtil.convertHexDigit((byte)source.next()) << 16) + (TypeUtil.convertHexDigit((byte)source.next()) << 8) + TypeUtil.convertHexDigit((byte)source.next())));
                        continue block8;
                    }
                }
                b.append(c);
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') break;
            b.append(c);
        }
        return b.toString();
    }

    private static Number parseNumber(Source source) {
        String s;
        int start = source.index();
        int end = -1;
        boolean is_double = false;
        block4: while (source.hasNext() && end < 0) {
            char c = source.peek();
            switch (c) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    source.next();
                    continue block4;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    is_double = true;
                    source.next();
                    continue block4;
                }
            }
            end = source.index();
        }
        String string = s = end >= 0 ? source.from(start, end) : source.from(start);
        if (is_double) {
            return new Double(s);
        }
        return new Long(s);
    }

    private static void seekTo(char seek, Source source) {
        while (source.hasNext()) {
            char c = source.peek();
            if (c == seek) {
                return;
            }
            if (!Character.isWhitespace(c)) {
                throw new IllegalStateException("Unexpected '" + c + " while seeking '" + seek + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected '" + seek + "'");
    }

    private static char seekTo(String seek, Source source) {
        while (source.hasNext()) {
            char c = source.peek();
            if (seek.indexOf(c) >= 0) {
                return c;
            }
            if (!Character.isWhitespace(c)) {
                throw new IllegalStateException("Unexpected '" + c + "' while seeking one of '" + seek + "'");
            }
            source.next();
        }
        throw new IllegalStateException("Expected one of '" + seek + "'");
    }

    private static void complete(String seek, Source source) {
        int i = 0;
        while (source.hasNext() && i < seek.length()) {
            char c = source.next();
            if (c == seek.charAt(i++)) continue;
            throw new IllegalStateException("Unexpected '" + c + " while seeking  \"" + seek + "\"");
        }
        if (i < seek.length()) {
            throw new IllegalStateException("Expected \"" + seek + "\"");
        }
    }

    public static class Literal
    implements Generator {
        private String _json;

        public Literal(String json) {
            JSON.parse(json);
            this._json = json;
        }

        public String toString() {
            return this._json;
        }

        public void addJSON(StringBuffer buffer) {
            buffer.append(this._json);
        }
    }

    public static interface Generator {
        public void addJSON(StringBuffer var1);
    }

    private static class Source {
        private final String string;
        private int index;

        Source(String s) {
            this.string = s;
        }

        boolean hasNext() {
            return this.index < this.string.length();
        }

        char next() {
            return this.string.charAt(this.index++);
        }

        char peek() {
            return this.string.charAt(this.index);
        }

        int index() {
            return this.index;
        }

        String from(int mark) {
            return this.string.substring(mark, this.index);
        }

        String from(int mark, int end) {
            return this.string.substring(mark, end);
        }
    }
}

