/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.WhiteboardSessionJabberImpl;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.PacketExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardSessionPacketExtension
implements PacketExtension {
    private Logger logger;
    public static final String ACTION_LEAVE = "LEAVE";
    public static final String ELEMENT_NAME = "xSession";
    public static final String NAMESPACE = "http://jabber.org/protocol/swb";
    private String action;
    private WhiteboardSessionJabberImpl whiteboardSession;
    private String contactAddress;
    private String whiteboardSessionId;

    public WhiteboardSessionPacketExtension(WhiteboardSessionJabberImpl session, String contactAddress, String action) {
        this.logger = Logger.getLogger(WhiteboardSessionPacketExtension.class);
        this.whiteboardSession = session;
        this.whiteboardSessionId = session.getWhiteboardID();
        this.contactAddress = contactAddress;
        this.action = action;
    }

    public WhiteboardSessionPacketExtension(String xml) {
        block9: {
            this.logger = Logger.getLogger(WhiteboardSessionPacketExtension.class);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals(ACTION_LEAVE)) {
                    this.setWhiteboardSessionId(e.getAttribute("id"));
                    this.setContactAddress(e.getAttribute("userId"));
                    this.action = ACTION_LEAVE;
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Element name unknown!");
                }
            }
            catch (ParserConfigurationException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem WhiteboardSession : " + xml), (Throwable)ex);
                }
            }
            catch (IOException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem WhiteboardSession : " + xml), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block9;
                this.logger.debug((Object)("Problem WhiteboardSession : " + xml), (Throwable)ex);
            }
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String toXML() {
        String s = "";
        if (this.action.equals(ACTION_LEAVE)) {
            s = "<LEAVE id=\"#sessionId\" userId=\"#userId\"/>";
            s = s.replaceAll("#sessionId", this.whiteboardSession.getWhiteboardID());
            s = s.replaceAll("#userId", this.contactAddress);
        }
        return "<xSession xmlns=\"http://jabber.org/protocol/swb\">" + s + "</" + ELEMENT_NAME + ">";
    }

    public String getWhiteboardSessionId() {
        return this.whiteboardSessionId;
    }

    public void setWhiteboardSessionId(String whiteboardSessionId) {
        this.whiteboardSessionId = whiteboardSessionId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getContactAddress() {
        return this.contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }
}

