/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Arrays;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.coin.CoinIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CoinPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetVideoBridge;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.media.ConferenceInfoDocument;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallConference;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLException;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class OperationSetTelephonyConferencingJabberImpl
extends AbstractOperationSetTelephonyConferencing<ProtocolProviderServiceJabberImpl, OperationSetBasicTelephonyJabberImpl, CallJabberImpl, CallPeerJabberImpl, String>
implements RegistrationStateChangeListener,
PacketListener,
PacketFilter {
    private static final Logger logger = Logger.getLogger(OperationSetTelephonyConferencingJabberImpl.class);
    private static final int COIN_MIN_INTERVAL = 200;
    private final Object lock = new Object();

    public OperationSetTelephonyConferencingJabberImpl(ProtocolProviderServiceJabberImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCallPeers(Call call) {
        if (call.isConferenceFocus()) {
            Object object = this.lock;
            synchronized (object) {
                Iterator i = call.getCallPeers();
                while (i.hasNext()) {
                    this.notify((CallPeer)i.next());
                }
            }
        }
    }

    private void notify(CallPeer callPeer) {
        if (!(callPeer instanceof CallPeerJabberImpl)) {
            return;
        }
        CallPeerState peerState = callPeer.getState();
        if (peerState == CallPeerState.CONNECTING || peerState == CallPeerState.UNKNOWN || peerState == CallPeerState.INITIATING_CALL || peerState == CallPeerState.DISCONNECTED || peerState == CallPeerState.FAILED) {
            return;
        }
        final CallPeerJabberImpl callPeerJabber = (CallPeerJabberImpl)callPeer;
        final long timeSinceLastCoin = System.currentTimeMillis() - callPeerJabber.getLastConferenceInfoSentTimestamp();
        if (timeSinceLastCoin < 200L) {
            if (callPeerJabber.isConfInfoScheduled()) {
                return;
            }
            logger.info((Object)("Scheduling to send a COIN to " + (Object)((Object)callPeerJabber)));
            callPeerJabber.setConfInfoScheduled(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(201L - timeSinceLastCoin);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    OperationSetTelephonyConferencingJabberImpl.this.notify((CallPeer)callPeerJabber);
                }
            }).start();
            return;
        }
        String to = ((OperationSetBasicTelephonyJabberImpl)this.getBasicTelephony()).getFullCalleeURI(callPeer.getAddress());
        try {
            DiscoverInfo discoverInfo = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getDiscoveryManager().discoverInfo(to);
            if (!discoverInfo.containsFeature("urn:xmpp:coin")) {
                logger.info((Object)(String.valueOf(callPeer.getAddress()) + " does not support COIN"));
                callPeerJabber.setConfInfoScheduled(false);
                return;
            }
        }
        catch (XMPPException xmppe) {
            logger.warn((Object)("Failed to retrieve DiscoverInfo for " + to), (Throwable)xmppe);
        }
        ConferenceInfoDocument currentConfInfo = this.getCurrentConferenceInfo(callPeerJabber);
        ConferenceInfoDocument lastSentConfInfo = callPeerJabber.getLastConferenceInfoSent();
        ConferenceInfoDocument diff = lastSentConfInfo == null ? currentConfInfo : this.getConferenceInfoDiff(lastSentConfInfo, currentConfInfo);
        if (diff != null) {
            int newVersion = lastSentConfInfo == null ? 1 : lastSentConfInfo.getVersion() + 1;
            diff.setVersion(newVersion);
            IQ iq = this.getConferenceInfo(callPeerJabber, diff);
            if (iq != null) {
                ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendPacket((Packet)iq);
                currentConfInfo.setVersion(newVersion);
                callPeerJabber.setLastConferenceInfoSent(currentConfInfo);
                callPeerJabber.setLastConferenceInfoSentTimestamp(System.currentTimeMillis());
            }
        }
        callPeerJabber.setConfInfoScheduled(false);
    }

    private IQ getConferenceInfo(CallPeerJabberImpl callPeer, final ConferenceInfoDocument confInfo) {
        String callPeerSID = callPeer.getSID();
        if (callPeerSID == null) {
            return null;
        }
        IQ iq = new IQ(){

            public String getChildElementXML() {
                return confInfo.toXml();
            }
        };
        CallJabberImpl call = (CallJabberImpl)callPeer.getCall();
        iq.setFrom(((ProtocolProviderServiceJabberImpl)call.getProtocolProvider()).getOurJID());
        iq.setTo(callPeer.getAddress());
        iq.setType(IQ.Type.SET);
        return iq;
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        super.registrationStateChanged(evt);
        RegistrationState registrationState = evt.getNewState();
        if (RegistrationState.REGISTERED.equals((Object)registrationState)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Subscribes to Coin packets");
            }
            this.subscribeForCoinPackets();
        } else if (RegistrationState.UNREGISTERED.equals((Object)registrationState)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unsubscribes to Coin packets");
            }
            this.unsubscribeForCoinPackets();
        }
    }

    protected CallJabberImpl createOutgoingCall() throws OperationFailedException {
        return new CallJabberImpl((OperationSetBasicTelephonyJabberImpl)this.getBasicTelephony());
    }

    protected CallPeer doInviteCalleeToCall(String calleeAddress, CallJabberImpl call) throws OperationFailedException {
        return ((OperationSetBasicTelephonyJabberImpl)this.getBasicTelephony()).createOutgoingCall(call, calleeAddress, Arrays.asList(new CoinPacketExtension(true)));
    }

    protected String parseAddressString(String calleeAddressString) throws OperationFailedException {
        return ((OperationSetBasicTelephonyJabberImpl)this.getBasicTelephony()).getFullCalleeURI(calleeAddressString);
    }

    private void subscribeForCoinPackets() {
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().addPacketListener((PacketListener)this, (PacketFilter)this);
    }

    private void unsubscribeForCoinPackets() {
        XMPPConnection connection = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection();
        if (connection != null) {
            connection.removePacketListener((PacketListener)this);
        }
    }

    public boolean accept(Packet packet) {
        return packet instanceof CoinIQ;
    }

    public void processPacket(Packet packet) {
        CallPeerJabberImpl callPeer;
        CoinIQ coinIQ = (CoinIQ)packet;
        String errorMessage = null;
        IQ.Type type = coinIQ.getType();
        if (type == IQ.Type.SET) {
            IQ ack = IQ.createResultIQ((IQ)coinIQ);
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendPacket((Packet)ack);
        } else if (type == IQ.Type.ERROR) {
            XMPPError error = coinIQ.getError();
            if (error != null) {
                String msg = error.getMessage();
                errorMessage = String.valueOf(msg != null ? String.valueOf(msg) + " " : "") + "Error code: " + error.getCode();
            }
            logger.error((Object)("Received error in COIN packet. " + errorMessage));
        }
        String sid = coinIQ.getSID();
        if (sid != null && (callPeer = ((OperationSetBasicTelephonyJabberImpl)this.getBasicTelephony()).getActiveCallsRepository().findCallPeer(sid)) != null) {
            if (type == IQ.Type.ERROR) {
                callPeer.fireConferenceMemberErrorEvent(errorMessage);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing COIN from " + coinIQ.getFrom() + " (version=" + coinIQ.getVersion() + ")"));
            }
            this.handleCoin(callPeer, coinIQ);
        }
    }

    private void handleCoin(CallPeerJabberImpl callPeer, CoinIQ coinIQ) {
        try {
            this.setConferenceInfoXML(callPeer, coinIQ.getChildElementXML());
        }
        catch (XMLException e) {
            logger.error((Object)("Could not handle received COIN from " + (Object)((Object)callPeer) + ": " + (Object)((Object)coinIQ)));
        }
    }

    protected ConferenceInfoDocument getCurrentConferenceInfo(MediaAwareCallPeer<?, ?, ?> callPeer) {
        ConferenceInfoDocument confInfo = super.getCurrentConferenceInfo(callPeer);
        if (callPeer instanceof CallPeerJabberImpl && confInfo != null) {
            confInfo.setSid(((CallPeerJabberImpl)callPeer).getSID());
        }
        return confInfo;
    }

    protected String getLocalEntity(CallPeer callPeer) {
        JingleIQ sessionIQ = ((CallPeerJabberImpl)callPeer).getSessionIQ();
        String from = sessionIQ.getFrom();
        String chatRoomName = StringUtils.parseBareAddress((String)from);
        OperationSetMultiUserChatJabberImpl opSetMUC = (OperationSetMultiUserChatJabberImpl)((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(OperationSetMultiUserChat.class);
        ChatRoomJabberImpl room = null;
        room = opSetMUC.getChatRoom(chatRoomName);
        if (room != null) {
            return "xmpp:" + chatRoomName + "/" + room.getUserNickname();
        }
        return "xmpp:" + ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID();
    }

    protected String getLocalDisplayName() {
        return null;
    }

    public ConferenceDescription setupConference(final ChatRoom chatRoom) {
        OperationSetVideoBridge videoBridge = (OperationSetVideoBridge)((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(OperationSetVideoBridge.class);
        boolean isVideobridge = videoBridge != null && videoBridge.isActive();
        CallJabberImpl call = new CallJabberImpl((OperationSetBasicTelephonyJabberImpl)this.getBasicTelephony());
        call.setAutoAnswer(true);
        String uri = "xmpp:" + chatRoom.getIdentifier() + "/" + chatRoom.getUserNickname();
        ConferenceDescription cd = new ConferenceDescription(uri, call.getCallID());
        call.addCallChangeListener(new CallChangeListener(){

            public void callStateChanged(CallChangeEvent ev) {
                if (CallState.CALL_ENDED.equals(ev.getNewValue())) {
                    chatRoom.publishConference(null, null);
                }
            }

            public void callPeerRemoved(CallPeerEvent ev) {
            }

            public void callPeerAdded(CallPeerEvent ev) {
            }
        });
        if (isVideobridge) {
            call.setConference((CallConference)new MediaAwareCallConference(true));
            cd.addTransport("urn:xmpp:jingle:transports:raw-udp:1");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Setup a conference with uri=" + uri + " and callid=" + call.getCallID() + ". Videobridge in use: " + isVideobridge));
        }
        return cd;
    }
}

