/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ScServiceDiscoveryManager;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.UserCapsNodeListener;
import net.java.sip.communicator.service.protocol.AbstractOperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetMessageCorrection;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;

public class OperationSetContactCapabilitiesJabberImpl
extends AbstractOperationSetContactCapabilities<ProtocolProviderServiceJabberImpl>
implements UserCapsNodeListener,
ContactPresenceStatusListener {
    private static final Logger logger = Logger.getLogger(OperationSetContactCapabilitiesJabberImpl.class);
    private static final Set<Class<? extends OperationSet>> OFFLINE_OPERATION_SETS = new HashSet<Class<? extends OperationSet>>();
    private static final Map<Class<? extends OperationSet>, String[]> OPERATION_SETS_TO_FEATURES = new HashMap<Class<? extends OperationSet>, String[]>();
    private static final Map<Class<? extends OperationSet>, String[]> CAPS_OPERATION_SETS_TO_FEATURES = new HashMap<Class<? extends OperationSet>, String[]>();
    private EntityCapsManager capsManager;

    static {
        OFFLINE_OPERATION_SETS.add(OperationSetBasicInstantMessaging.class);
        OFFLINE_OPERATION_SETS.add(OperationSetMessageCorrection.class);
        OFFLINE_OPERATION_SETS.add(OperationSetServerStoredContactInfo.class);
        OPERATION_SETS_TO_FEATURES.put(OperationSetBasicTelephony.class, new String[]{"urn:xmpp:jingle:1", "urn:xmpp:jingle:apps:rtp:1", "urn:xmpp:jingle:apps:rtp:audio"});
        OPERATION_SETS_TO_FEATURES.put(OperationSetVideoTelephony.class, new String[]{"urn:xmpp:jingle:1", "urn:xmpp:jingle:apps:rtp:1", "urn:xmpp:jingle:apps:rtp:video"});
        OPERATION_SETS_TO_FEATURES.put(OperationSetDesktopSharingServer.class, new String[]{"urn:xmpp:jingle:1", "urn:xmpp:jingle:apps:rtp:1", "urn:xmpp:jingle:apps:rtp:video"});
        OPERATION_SETS_TO_FEATURES.put(OperationSetMessageCorrection.class, new String[]{"urn:xmpp:message-correct:0"});
        CAPS_OPERATION_SETS_TO_FEATURES.put(OperationSetBasicTelephony.class, new String[]{"voice-v1"});
        CAPS_OPERATION_SETS_TO_FEATURES.put(OperationSetVideoTelephony.class, new String[]{"voice-v1", "video-v1"});
    }

    public OperationSetContactCapabilitiesJabberImpl(ProtocolProviderServiceJabberImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
        OperationSetPresence presenceOpSet = (OperationSetPresence)parentProvider.getOperationSet(OperationSetPresence.class);
        if (presenceOpSet != null) {
            presenceOpSet.addContactPresenceStatusListener((ContactPresenceStatusListener)this);
        }
    }

    protected <U extends OperationSet> U getOperationSet(Contact contact, Class<U> opsetClass, boolean online) {
        String jid = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getFullJid(contact);
        if (jid == null) {
            jid = contact.getAddress();
        }
        return this.getOperationSet(jid, opsetClass, online);
    }

    protected Map<String, OperationSet> getSupportedOperationSets(Contact contact, boolean online) {
        String jid = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getFullJid(contact);
        if (jid == null) {
            jid = contact.getAddress();
        }
        return this.getSupportedOperationSets(jid, online);
    }

    private Map<String, OperationSet> getSupportedOperationSets(String jid, boolean online) {
        Map supportedOperationSets = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getSupportedOperationSets();
        int supportedOperationSetCount = supportedOperationSets.size();
        HashMap<String, OperationSet> contactSupportedOperationSets = new HashMap<String, OperationSet>(supportedOperationSetCount);
        if (supportedOperationSetCount != 0) {
            for (Map.Entry supportedOperationSetEntry : supportedOperationSets.entrySet()) {
                Object opset;
                Class<?> opsetClass;
                String opsetClassName = (String)supportedOperationSetEntry.getKey();
                try {
                    opsetClass = Class.forName(opsetClassName);
                }
                catch (ClassNotFoundException cnfex) {
                    opsetClass = null;
                    logger.error((Object)("Failed to get OperationSet class for name: " + opsetClassName), (Throwable)cnfex);
                }
                if (opsetClass == null || (opset = this.getOperationSet(jid, opsetClass, online)) == null) continue;
                contactSupportedOperationSets.put(opsetClassName, (OperationSet)opset);
            }
        }
        return contactSupportedOperationSets;
    }

    private <U extends OperationSet> U getOperationSet(String jid, Class<U> opsetClass, boolean online) {
        String[] features;
        OperationSet opset = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(opsetClass);
        if (opset == null) {
            return null;
        }
        if (!online) {
            return (U)(OFFLINE_OPERATION_SETS.contains(opsetClass) ? opset : null);
        }
        if (OPERATION_SETS_TO_FEATURES.containsKey(opsetClass) && ((features = OPERATION_SETS_TO_FEATURES.get(opsetClass)) == null || features.length != 0 && !((ProtocolProviderServiceJabberImpl)this.parentProvider).isFeatureListSupported(jid, features))) {
            if (CAPS_OPERATION_SETS_TO_FEATURES.containsKey(opsetClass)) {
                String[] extFeatures = CAPS_OPERATION_SETS_TO_FEATURES.get(opsetClass);
                if (!((ProtocolProviderServiceJabberImpl)this.parentProvider).isGTalkTesting()) {
                    opset = null;
                } else if (extFeatures == null || extFeatures.length != 0 && !((ProtocolProviderServiceJabberImpl)this.parentProvider).isExtFeatureListSupported(jid, extFeatures)) {
                    opset = null;
                }
            } else {
                opset = null;
            }
        }
        return (U)opset;
    }

    private void setCapsManager(EntityCapsManager capsManager) {
        if (this.capsManager != capsManager) {
            if (this.capsManager != null) {
                this.capsManager.removeUserCapsNodeListener(this);
            }
            this.capsManager = capsManager;
            if (this.capsManager != null) {
                this.capsManager.addUserCapsNodeListener(this);
            }
        }
    }

    void setDiscoveryManager(ScServiceDiscoveryManager discoveryManager) {
        this.setCapsManager(discoveryManager == null ? null : discoveryManager.getCapsManager());
    }

    @Override
    public void userCapsNodeAdded(String user, String node, boolean online) {
        this.userCapsNodeRemoved(user, node, online);
    }

    @Override
    public void userCapsNodeRemoved(String user, String node, boolean online) {
        String jid;
        Contact contact;
        OperationSetPresence opsetPresence = (OperationSetPresence)((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(OperationSetPresence.class);
        if (opsetPresence != null && (contact = opsetPresence.findContactByID(jid = StringUtils.parseBareAddress((String)user))) != null) {
            if (online) {
                this.fireContactCapabilitiesEvent(contact, 1, this.getSupportedOperationSets(user, online));
            } else {
                this.fireContactCapabilitiesEvent(contact, 1, this.getSupportedOperationSets(contact));
            }
        }
    }

    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        if (this.capsManager != null && evt.getNewStatus().getStatus() < 20) {
            this.capsManager.removeContactCapsNode(evt.getSourceContact());
        }
    }

    public void fireContactCapabilitiesChanged(String user) {
        OperationSetPresence opsetPresence = (OperationSetPresence)((ProtocolProviderServiceJabberImpl)this.parentProvider).getOperationSet(OperationSetPresence.class);
        if (opsetPresence != null) {
            String userID = StringUtils.parseBareAddress((String)user);
            Contact contact = opsetPresence.findContactByID(userID);
            boolean online = false;
            Presence presence = ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().getRoster().getPresence(user);
            if (presence != null) {
                online = presence.isAvailable();
            }
            if (contact != null) {
                this.fireContactCapabilitiesEvent(contact, 1, this.getSupportedOperationSets(user, online));
            }
        }
    }
}

