/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.xmpp.jnodes.smack.SmackServiceNode;
import org.xmpp.jnodes.smack.TrackerEntry;

public class JingleNodesServiceDiscovery
implements Runnable {
    private static final Logger logger = Logger.getLogger(JingleNodesServiceDiscovery.class);
    private static final String JINGLE_NODES_SEARCH_PREFIX_PROP = "net.java.sip.communicator.impl.protocol.jabber.JINGLE_NODES_SEARCH_PREFIXES";
    private static final String JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST_PROP = "net.java.sip.communicator.impl.protocol.jabber.JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST";
    private final Object jingleNodesSyncRoot;
    private final SmackServiceNode service;
    private final XMPPConnection connection;
    private final JabberAccountIDImpl accountID;

    JingleNodesServiceDiscovery(SmackServiceNode service, XMPPConnection connection, JabberAccountIDImpl accountID, Object syncRoot) {
        this.jingleNodesSyncRoot = syncRoot;
        this.service = service;
        this.connection = connection;
        this.accountID = accountID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.jingleNodesSyncRoot;
        synchronized (object) {
            String searchNodesWithPrefix;
            long start = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Start Jingle Nodes discovery!");
            }
            if ((searchNodesWithPrefix = JabberActivator.getResources().getSettingsString(JINGLE_NODES_SEARCH_PREFIX_PROP)) == null || searchNodesWithPrefix.length() == 0) {
                searchNodesWithPrefix = JabberActivator.getConfigurationService().getString(JINGLE_NODES_SEARCH_PREFIX_PROP);
            }
            if (searchNodesWithPrefix == null || searchNodesWithPrefix.length() == 0 || searchNodesWithPrefix.equalsIgnoreCase("off")) {
                searchNodesWithPrefix = "";
            }
            SmackServiceNode.MappedNodes nodes = this.searchServicesWithPrefix(this.service, this.connection, 6, 3, 20, "udp", this.accountID.isJingleNodesSearchBuddiesEnabled(), this.accountID.isJingleNodesAutoDiscoveryEnabled(), searchNodesWithPrefix);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Jingle Nodes discovery terminated! ");
                logger.info((Object)("Found " + (nodes != null ? Integer.valueOf(nodes.getRelayEntries().size()) : "0") + " Jingle Nodes relay for account: " + this.accountID.getAccountAddress() + " in " + (System.currentTimeMillis() - start) + " ms."));
            }
            if (nodes != null) {
                this.service.addEntries(nodes);
            }
        }
    }

    private SmackServiceNode.MappedNodes searchServicesWithPrefix(SmackServiceNode service, XMPPConnection xmppConnection, int maxEntries, int maxDepth, int maxSearchNodes, String protocol, boolean searchBuddies, boolean autoDiscover, String prefix) {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        SmackServiceNode.MappedNodes mappedNodes = new SmackServiceNode.MappedNodes();
        ConcurrentHashMap<String, String> visited = new ConcurrentHashMap<String, String>();
        for (Map.Entry entry : service.getTrackerEntries().entrySet()) {
            SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (String)((TrackerEntry)entry.getValue()).getJid(), (SmackServiceNode.MappedNodes)mappedNodes, (int)(maxDepth - 1), (int)maxSearchNodes, (String)protocol, visited);
        }
        if (autoDiscover) {
            boolean continueSearch = JingleNodesServiceDiscovery.searchDiscoItems(service, xmppConnection, maxEntries, xmppConnection.getServiceName(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited, prefix);
            if (!continueSearch) {
                return mappedNodes;
            }
            SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (String)xmppConnection.getHost(), (SmackServiceNode.MappedNodes)mappedNodes, (int)(maxDepth - 1), (int)maxSearchNodes, (String)protocol, visited);
            if (xmppConnection.getRoster() != null && searchBuddies) {
                for (RosterEntry re : xmppConnection.getRoster().getEntries()) {
                    Iterator i = xmppConnection.getRoster().getPresences(re.getUser());
                    while (i.hasNext()) {
                        Presence presence = (Presence)i.next();
                        if (!presence.isAvailable()) continue;
                        SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (String)presence.getFrom(), (SmackServiceNode.MappedNodes)mappedNodes, (int)(maxDepth - 1), (int)maxSearchNodes, (String)protocol, visited);
                    }
                }
            }
        }
        return null;
    }

    private static boolean searchDiscoItems(SmackServiceNode service, XMPPConnection xmppConnection, int maxEntries, String startPoint, SmackServiceNode.MappedNodes mappedNodes, int maxDepth, int maxSearchNodes, String protocol, ConcurrentHashMap<String, String> visited, String prefix) {
        String[] prefixes = prefix.split(",");
        boolean stopOnFirst = true;
        String stopOnFirstDefaultValue = JabberActivator.getResources().getSettingsString(JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST_PROP);
        if (stopOnFirstDefaultValue != null) {
            stopOnFirst = Boolean.parseBoolean(stopOnFirstDefaultValue);
        }
        stopOnFirst = JabberActivator.getConfigurationService().getBoolean(JINGLE_NODES_SEARCH_PREFIXES_STOP_ON_FIRST_PROP, stopOnFirst);
        DiscoverItems items = new DiscoverItems();
        items.setTo(startPoint);
        PacketCollector collector = xmppConnection.createPacketCollector((PacketFilter)new PacketIDFilter(items.getPacketID()));
        xmppConnection.sendPacket((Packet)items);
        DiscoverItems result = (DiscoverItems)collector.nextResult(Math.round((double)SmackConfiguration.getPacketReplyTimeout() * 1.5));
        if (result != null) {
            Iterator i = result.getItems();
            DiscoverItems.Item item = i.hasNext() ? (DiscoverItems.Item)i.next() : null;
            while (item != null) {
                String[] stringArray = prefixes;
                int n = prefixes.length;
                int n2 = 0;
                while (n2 < n) {
                    String pref = stringArray[n2];
                    if (!StringUtils.isNullOrEmpty((String)pref) && item.getEntityID().startsWith(pref.trim())) {
                        SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (String)item.getEntityID(), (SmackServiceNode.MappedNodes)mappedNodes, (int)maxDepth, (int)maxSearchNodes, (String)protocol, visited);
                        if (stopOnFirst) {
                            return false;
                        }
                    }
                    ++n2;
                }
                DiscoverItems.Item item2 = item = i.hasNext() ? (DiscoverItems.Item)i.next() : null;
            }
            i = result.getItems();
            item = i.hasNext() ? (DiscoverItems.Item)i.next() : null;
            while (item != null) {
                if (!visited.containsKey(item.getEntityID())) {
                    SmackServiceNode.deepSearch((XMPPConnection)xmppConnection, (int)maxEntries, (String)item.getEntityID(), (SmackServiceNode.MappedNodes)mappedNodes, (int)maxDepth, (int)maxSearchNodes, (String)protocol, visited);
                }
                if (stopOnFirst) {
                    return false;
                }
                DiscoverItems.Item item3 = item = i.hasNext() ? (DiscoverItems.Item)i.next() : null;
            }
        }
        collector.cancel();
        return true;
    }
}

