/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.device.MediaDeviceWrapper;
import org.jitsi.util.OSUtils;
import org.jitsi.util.event.PropertyChangeNotifier;

public class MediaAwareCallConference
extends CallConference {
    private static WeakPropertyChangeListener mediaServicePropertyChangeListener;
    private final MediaDevice[] devices;
    private final MediaDevice[] mixers;
    private final VolumeControl outputVolumeControl = new BasicVolumeControl("net.java.sip.communicator.service.media.PLAYBACK_VOLUME_LEVEL");
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            MediaAwareCallConference.this.propertyChange(ev);
        }
    };
    private RTPTranslator videoRTPTranslator;

    public MediaAwareCallConference() {
        this(false);
    }

    public MediaAwareCallConference(boolean jitsiVideobridge) {
        super(jitsiVideobridge);
        int mediaTypeCount = MediaType.values().length;
        this.devices = new MediaDevice[mediaTypeCount];
        this.mixers = new MediaDevice[mediaTypeCount];
        MediaAwareCallConference.addMediaServicePropertyChangeListener(this.propertyChangeListener);
    }

    private static synchronized void addMediaServicePropertyChangeListener(PropertyChangeListener listener) {
        MediaService mediaService;
        if (mediaServicePropertyChangeListener == null && (mediaService = ProtocolMediaActivator.getMediaService()) != null) {
            mediaServicePropertyChangeListener = new WeakPropertyChangeListener(){

                @Override
                protected void addThisToNotifier() {
                    mediaService.addPropertyChangeListener((PropertyChangeListener)this);
                }

                @Override
                protected void removeThisFromNotifier() {
                    mediaService.removePropertyChangeListener((PropertyChangeListener)this);
                }
            };
        }
        if (mediaServicePropertyChangeListener != null) {
            mediaServicePropertyChangeListener.addPropertyChangeListener(listener);
        }
    }

    @Override
    protected void conferenceFocusChanged(boolean oldValue, boolean newValue) {
        if (oldValue && !newValue) {
            Arrays.fill(this.mixers, null);
            if (this.videoRTPTranslator != null) {
                this.videoRTPTranslator.dispose();
                this.videoRTPTranslator = null;
            }
        }
        super.conferenceFocusChanged(oldValue, newValue);
    }

    @Override
    protected void callRemoved(Call call) {
        super.callRemoved(call);
        if (this.getCallCount() == 0 && this.videoRTPTranslator != null) {
            this.videoRTPTranslator.dispose();
            this.videoRTPTranslator = null;
        }
    }

    public MediaDevice getDefaultDevice(MediaType mediaType, MediaUseCase useCase) {
        int mediaTypeIndex = mediaType.ordinal();
        MediaDevice device = this.devices[mediaTypeIndex];
        MediaService mediaService = ProtocolMediaActivator.getMediaService();
        if (device == null) {
            device = mediaService.getDefaultDevice(mediaType, useCase);
        }
        if (device != null) {
            MediaDevice mixer = this.mixers[mediaTypeIndex];
            if (mixer == null) {
                switch (mediaType) {
                    case AUDIO: {
                        if (OSUtils.IS_ANDROID && !this.isConferenceFocus() || !device.getDirection().allowsSending()) break;
                        mixer = mediaService.createMixer(device);
                        break;
                    }
                    case VIDEO: {
                        if (!this.isConferenceFocus()) break;
                        mixer = mediaService.createMixer(device);
                    }
                }
                this.mixers[mediaTypeIndex] = mixer;
            }
            if (mixer != null) {
                device = mixer;
            }
        }
        return device;
    }

    public VolumeControl getOutputVolumeControl() {
        return this.outputVolumeControl;
    }

    public RTPTranslator getRTPTranslator(MediaType mediaType) {
        RTPTranslator rtpTranslator = null;
        if (MediaType.VIDEO.equals((Object)mediaType) && (!OSUtils.IS_ANDROID || this.isConferenceFocus())) {
            if (this.videoRTPTranslator == null) {
                this.videoRTPTranslator = ProtocolMediaActivator.getMediaService().createRTPTranslator();
            }
            rtpTranslator = this.videoRTPTranslator;
        }
        return rtpTranslator;
    }

    private void propertyChange(PropertyChangeEvent ev) {
        Object source;
        String propertyName = ev.getPropertyName();
        if ("defaultDevice".equals(propertyName) && (source = ev.getSource()) instanceof MediaService) {
            int mediaTypeIndex = MediaType.AUDIO.ordinal();
            MediaDevice mixer = this.mixers[mediaTypeIndex];
            MediaDevice oldValue = mixer instanceof MediaDeviceWrapper ? ((MediaDeviceWrapper)mixer).getWrappedDevice() : null;
            MediaDevice newValue = this.devices[mediaTypeIndex];
            if (newValue == null) {
                newValue = ProtocolMediaActivator.getMediaService().getDefaultDevice(MediaType.AUDIO, MediaUseCase.ANY);
            }
            if (oldValue != newValue) {
                this.mixers[mediaTypeIndex] = null;
                this.firePropertyChange("defaultDevice", oldValue, newValue);
            }
        }
    }

    void setDevice(MediaType mediaType, MediaDevice device) {
        MediaDevice newValue;
        int mediaTypeIndex = mediaType.ordinal();
        MediaDevice oldValue = this.devices[mediaTypeIndex];
        MediaDevice mixer = this.mixers[mediaTypeIndex];
        if (mixer instanceof MediaDeviceWrapper) {
            oldValue = ((MediaDeviceWrapper)mixer).getWrappedDevice();
        }
        if (oldValue != (newValue = (this.devices[mediaTypeIndex] = device))) {
            this.mixers[mediaTypeIndex] = null;
            this.firePropertyChange("defaultDevice", oldValue, newValue);
        }
    }

    private static class WeakPropertyChangeListener
    implements PropertyChangeListener {
        private boolean added = false;
        private final List<WeakReference<PropertyChangeListener>> listeners = new LinkedList<WeakReference<PropertyChangeListener>>();
        private final PropertyChangeNotifier notifier;

        protected WeakPropertyChangeListener() {
            this(null);
        }

        public WeakPropertyChangeListener(PropertyChangeNotifier notifier) {
            this.notifier = notifier;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            Iterator<WeakReference<PropertyChangeListener>> i = this.listeners.iterator();
            boolean add = true;
            while (i.hasNext()) {
                PropertyChangeListener l = (PropertyChangeListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                add = false;
            }
            if (add && this.listeners.add(new WeakReference<PropertyChangeListener>(listener)) && !this.added) {
                this.addThisToNotifier();
                this.added = true;
            }
        }

        protected void addThisToNotifier() {
            if (this.notifier != null) {
                this.notifier.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            int n;
            PropertyChangeListener[] ls;
            WeakPropertyChangeListener weakPropertyChangeListener = this;
            synchronized (weakPropertyChangeListener) {
                Iterator<WeakReference<PropertyChangeListener>> i = this.listeners.iterator();
                ls = new PropertyChangeListener[this.listeners.size()];
                n = 0;
                while (i.hasNext()) {
                    PropertyChangeListener l = (PropertyChangeListener)i.next().get();
                    if (l == null) {
                        i.remove();
                        continue;
                    }
                    ls[n++] = l;
                }
                if (n == 0 && this.added) {
                    this.removeThisFromNotifier();
                    this.added = false;
                }
            }
            if (n != 0) {
                PropertyChangeListener[] propertyChangeListenerArray = ls;
                int n2 = ls.length;
                int n3 = 0;
                while (n3 < n2) {
                    PropertyChangeListener l = propertyChangeListenerArray[n3];
                    if (l == null) break;
                    l.propertyChange(ev);
                    ++n3;
                }
            }
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            Iterator<WeakReference<PropertyChangeListener>> i = this.listeners.iterator();
            while (i.hasNext()) {
                PropertyChangeListener l = (PropertyChangeListener)i.next().get();
                if (l != null && !l.equals(listener)) continue;
                i.remove();
            }
            if (this.added && this.listeners.size() == 0) {
                this.removeThisFromNotifier();
                this.added = false;
            }
        }

        protected void removeThisFromNotifier() {
            if (this.notifier != null) {
                this.notifier.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

