/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetCusaxUtils;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class SingleCallInProgressPolicy {
    private static final String PNAME_SINGLE_CALL_IN_PROGRESS_POLICY_ENABLED = "net.java.sip.communicator.impl.protocol.SingleCallInProgressPolicy.enabled";
    private static final String PNAME_CALL_WAITING_DISABLED = "net.java.sip.communicator.impl.protocol.CallWaitingDisabled";
    private static final String ACCOUNT_PROPERTY_REJECT_IN_CALL_ON_DND = "RejectIncomingCallsWhenDnD";
    private static final String PNAME_REJECT_IN_CALL_ON_DND = "net.java.sip.communicator.impl.protocol.RejectIncomingCallsWhenDnD";
    private static final Logger logger = Logger.getLogger(SingleCallInProgressPolicy.class);
    private final BundleContext bundleContext;
    private final List<Call> calls = new ArrayList<Call>();
    private final SingleCallInProgressPolicyListener listener = new SingleCallInProgressPolicyListener();

    public SingleCallInProgressPolicy(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.bundleContext.addServiceListener((ServiceListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallListener(Call call) {
        List<Call> list = this.calls;
        synchronized (list) {
            CallState callState;
            if (!this.calls.contains(call) && (callState = call.getCallState()) != null && !callState.equals(CallState.CALL_ENDED)) {
                this.calls.add(call);
            }
        }
        call.addCallChangeListener(this.listener);
    }

    private void addOperationSetBasicTelephonyListener(OperationSetBasicTelephony<? extends ProtocolProviderService> telephony) {
        telephony.addCallListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callStateChanged(CallChangeEvent callChangeEvent) {
        Call call = callChangeEvent.getSourceCall();
        if (CallState.CALL_INITIALIZATION.equals(callChangeEvent.getOldValue()) && CallState.CALL_IN_PROGRESS.equals(call.getCallState()) && ProtocolProviderActivator.getConfigurationService().getBoolean(PNAME_SINGLE_CALL_IN_PROGRESS_POLICY_ENABLED, true)) {
            CallConference conference = call.getConference();
            List<Call> list = this.calls;
            synchronized (list) {
                for (Call otherCall : this.calls) {
                    boolean putOnHold;
                    if (call.equals(otherCall) || !CallState.CALL_IN_PROGRESS.equals(otherCall.getCallState())) continue;
                    CallConference otherConference = otherCall.getConference();
                    if (conference == null) {
                        putOnHold = otherConference == null;
                    } else {
                        boolean bl = putOnHold = conference != otherConference;
                    }
                    if (!putOnHold) continue;
                    this.putOnHold(otherCall);
                }
            }
        }
    }

    public void dispose() {
        this.bundleContext.removeServiceListener((ServiceListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCallEvent(int type, CallEvent callEvent) {
        Call call = callEvent.getSourceCall();
        ProtocolProviderService provider = call.getProtocolProvider();
        switch (type) {
            case 3: {
                this.removeCallListener(call);
                break;
            }
            case 1: 
            case 2: {
                if (type == 2 && CallState.CALL_INITIALIZATION.equals(call.getCallState()) && ProtocolProviderActivator.getConfigurationService().getBoolean(PNAME_CALL_WAITING_DISABLED, false)) {
                    List<Call> list = this.calls;
                    synchronized (list) {
                        for (Call otherCall : this.calls) {
                            if (call.equals(otherCall) || !CallState.CALL_IN_PROGRESS.equals(otherCall.getCallState())) continue;
                            this.rejectCallWithBusyHere(call);
                            return;
                        }
                    }
                }
                if (type == 2 && CallState.CALL_INITIALIZATION.equals(call.getCallState()) && (ProtocolProviderActivator.getConfigurationService().getBoolean(PNAME_REJECT_IN_CALL_ON_DND, false) || provider.getAccountID().getAccountPropertyBoolean(ACCOUNT_PROPERTY_REJECT_IN_CALL_ON_DND, false))) {
                    ProtocolProviderService linkedCusaxProvider;
                    OperationSetCusaxUtils cusaxOpSet;
                    OperationSetPresence presence = provider.getOperationSet(OperationSetPresence.class);
                    if (presence == null && (cusaxOpSet = provider.getOperationSet(OperationSetCusaxUtils.class)) != null && (linkedCusaxProvider = cusaxOpSet.getLinkedCusaxProvider()) != null) {
                        presence = linkedCusaxProvider.getOperationSet(OperationSetPresence.class);
                    }
                    if (presence != null) {
                        int presenceStatus;
                        int n = presenceStatus = presence == null ? 50 : presence.getPresenceStatus().getStatus();
                        if (presenceStatus > 20 && presenceStatus <= 31) {
                            this.rejectCallWithBusyHere(call);
                            return;
                        }
                    }
                }
                this.addCallListener(call);
            }
        }
    }

    private void rejectCallWithBusyHere(Call call) {
        if (call.getCallPeerCount() == 1) {
            CallPeer peer = call.getCallPeers().next();
            OperationSetBasicTelephony telephony = call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
            if (telephony != null) {
                try {
                    telephony.hangupCallPeer(peer, 486, null);
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)("Failed to reject " + peer), (Throwable)ex);
                }
            }
        }
    }

    private void putOnHold(Call call) {
        OperationSetBasicTelephony telephony = call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
        if (telephony != null) {
            Iterator<? extends CallPeer> peerIter = call.getCallPeers();
            while (peerIter.hasNext()) {
                CallPeer peer = peerIter.next();
                CallPeerState peerState = peer.getState();
                if (CallPeerState.DISCONNECTED.equals(peerState) || CallPeerState.FAILED.equals(peerState) || CallPeerState.isOnHold(peerState)) continue;
                try {
                    telephony.putOnHold(peer);
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)("Failed to put " + peer + " on hold."), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallListener(Call call) {
        call.removeCallChangeListener(this.listener);
        List<Call> list = this.calls;
        synchronized (list) {
            this.calls.remove(call);
        }
    }

    private void removeOperationSetBasicTelephonyListener(OperationSetBasicTelephony<? extends ProtocolProviderService> telephony) {
        telephony.removeCallListener(this.listener);
    }

    private void serviceChanged(ServiceEvent serviceEvent) {
        OperationSetBasicTelephony telephony;
        Object service = this.bundleContext.getService(serviceEvent.getServiceReference());
        if (service instanceof ProtocolProviderService && (telephony = ((ProtocolProviderService)service).getOperationSet(OperationSetBasicTelephony.class)) != null) {
            switch (serviceEvent.getType()) {
                case 1: {
                    this.addOperationSetBasicTelephonyListener(telephony);
                    break;
                }
                case 4: {
                    this.removeOperationSetBasicTelephonyListener(telephony);
                }
            }
        }
    }

    private class SingleCallInProgressPolicyListener
    implements CallChangeListener,
    CallListener,
    ServiceListener {
        private SingleCallInProgressPolicyListener() {
        }

        @Override
        public void callEnded(CallEvent callEvent) {
            SingleCallInProgressPolicy.this.handleCallEvent(3, callEvent);
        }

        @Override
        public void callPeerAdded(CallPeerEvent callPeerEvent) {
        }

        @Override
        public void callPeerRemoved(CallPeerEvent callPeerEvent) {
        }

        @Override
        public void callStateChanged(CallChangeEvent callChangeEvent) {
            if (!callChangeEvent.getEventType().equals("CallState")) {
                return;
            }
            SingleCallInProgressPolicy.this.callStateChanged(callChangeEvent);
        }

        @Override
        public void incomingCallReceived(CallEvent callEvent) {
            SingleCallInProgressPolicy.this.handleCallEvent(2, callEvent);
        }

        @Override
        public void outgoingCallCreated(CallEvent callEvent) {
            SingleCallInProgressPolicy.this.handleCallEvent(1, callEvent);
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            SingleCallInProgressPolicy.this.serviceChanged(serviceEvent);
        }
    }
}

