/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.RemoteControlGrantedEvent;
import net.java.sip.communicator.service.protocol.event.RemoteControlListener;
import net.java.sip.communicator.service.protocol.event.RemoteControlRevokedEvent;

public abstract class AbstractOperationSetDesktopSharingClient<T extends ProtocolProviderService>
implements OperationSetDesktopSharingClient {
    private final CallPeerListener callPeerListener = new CallPeerAdapter(){

        @Override
        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeer peer = evt.getSourceCallPeer();
            CallPeerState state = peer.getState();
            if (state != null && (state.equals(CallPeerState.DISCONNECTED) || state.equals(CallPeerState.FAILED))) {
                AbstractOperationSetDesktopSharingClient.this.removesNullAndRevokedControlPeer(peer.getPeerID());
                AbstractOperationSetDesktopSharingClient.this.removeRemoteControlListener(AbstractOperationSetDesktopSharingClient.this.getListener(peer));
            }
        }
    };
    private Vector<CallPeer> grantedRemoteControlPeers = new Vector();
    private final List<WeakReference<RemoteControlListener>> listeners = new ArrayList<WeakReference<RemoteControlListener>>();
    protected final T parentProvider;

    protected AbstractOperationSetDesktopSharingClient(T parentProvider) {
        this.parentProvider = parentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteControlListener(RemoteControlListener listener) {
        List<WeakReference<RemoteControlListener>> list = this.listeners;
        synchronized (list) {
            Iterator<WeakReference<RemoteControlListener>> i = this.listeners.iterator();
            boolean contains = false;
            while (i.hasNext()) {
                RemoteControlListener l = (RemoteControlListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                contains = true;
            }
            if (!contains) {
                this.listeners.add(new WeakReference<RemoteControlListener>(listener));
                listener.getCallPeer().addCallPeerListener(this.callPeerListener);
            }
        }
        CallPeer peer = listener.getCallPeer();
        if (this.removesNullAndRevokedControlPeer(peer.getPeerID()) != -1) {
            listener.remoteControlGranted(new RemoteControlGrantedEvent(peer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRemoteControlGranted(CallPeer peer) {
        RemoteControlListener listener = this.getListener(peer);
        if (listener != null) {
            listener.remoteControlGranted(new RemoteControlGrantedEvent(peer));
        } else {
            this.removesNullAndRevokedControlPeer(peer.getPeerID());
            Vector<CallPeer> vector = this.grantedRemoteControlPeers;
            synchronized (vector) {
                this.grantedRemoteControlPeers.add(peer);
            }
        }
    }

    public void fireRemoteControlRevoked(CallPeer peer) {
        RemoteControlListener listener = this.getListener(peer);
        if (listener != null) {
            listener.remoteControlRevoked(new RemoteControlRevokedEvent(peer));
        }
        this.removesNullAndRevokedControlPeer(peer.getPeerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RemoteControlListener> getListeners() {
        ArrayList<RemoteControlListener> listeners;
        List<WeakReference<RemoteControlListener>> list = this.listeners;
        synchronized (list) {
            Iterator<WeakReference<RemoteControlListener>> i = this.listeners.iterator();
            listeners = new ArrayList<RemoteControlListener>(this.listeners.size());
            while (i.hasNext()) {
                RemoteControlListener l = (RemoteControlListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                listeners.add(l);
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemoteControlListener(RemoteControlListener listener) {
        List<WeakReference<RemoteControlListener>> list = this.listeners;
        synchronized (list) {
            Iterator<WeakReference<RemoteControlListener>> i = this.listeners.iterator();
            while (i.hasNext()) {
                RemoteControlListener l = (RemoteControlListener)i.next().get();
                if (l != null && !l.equals(listener)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removesNullAndRevokedControlPeer(String revokedPeerID) {
        int index = -1;
        Vector<CallPeer> vector = this.grantedRemoteControlPeers;
        synchronized (vector) {
            int i = 0;
            while (i < this.grantedRemoteControlPeers.size()) {
                CallPeer peer = this.grantedRemoteControlPeers.get(i);
                if (peer == null || peer.getPeerID().equals(revokedPeerID)) {
                    this.grantedRemoteControlPeers.remove(i);
                    index = i--;
                }
                ++i;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteControlListener getListener(CallPeer callPeer) {
        String peerID = callPeer.getPeerID();
        List<WeakReference<RemoteControlListener>> list = this.listeners;
        synchronized (list) {
            Iterator<WeakReference<RemoteControlListener>> i = this.listeners.iterator();
            while (i.hasNext()) {
                RemoteControlListener l = (RemoteControlListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!peerID.equals(l.getCallPeer().getPeerID())) continue;
                return l;
            }
        }
        return null;
    }
}

