/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.direct;

import com.lowagie.text.rtf.direct.RtfColorTableParser;
import com.lowagie.text.rtf.direct.RtfDirectContent;
import com.lowagie.text.rtf.direct.RtfFontTableParser;
import com.lowagie.text.rtf.direct.RtfImportHeader;
import com.lowagie.text.rtf.direct.RtfImportMappings;
import com.lowagie.text.rtf.direct.RtfTokeniser;
import com.lowagie.text.rtf.document.RtfDocument;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class RtfParser {
    private static final int PARSER_IN_HEADER = 0;
    private static final int PARSER_IN_FONT_TABLE = 1;
    private static final int PARSER_IN_COLOR_TABLE = 2;
    private static final int PARSER_IN_INFO_GROUP = 4;
    private static final int PARSER_IN_DOCUMENT = 8;
    private RtfDocument rtfDoc = null;
    private RtfTokeniser tokeniser = null;
    private RtfImportHeader importHeader = null;
    private RtfFontTableParser fontTableParser = null;
    private RtfColorTableParser colorTableParser = null;
    private int state = 0;

    public void importRtfDocument(Reader reader, RtfDocument rtfDoc) throws IOException {
        this.rtfDoc = rtfDoc;
        this.state = 0;
        this.importHeader = new RtfImportHeader(this.rtfDoc);
        this.fontTableParser = new RtfFontTableParser(this.importHeader);
        this.colorTableParser = new RtfColorTableParser(this.importHeader);
        this.tokeniser = new RtfTokeniser(this, 0);
        this.tokeniser.tokenise(reader);
    }

    public void importRtfFragment(Reader reader, RtfDocument rtfDoc, RtfImportMappings importMappings) throws IOException {
        this.rtfDoc = rtfDoc;
        this.state = 8;
        this.importHeader = new RtfImportHeader(this.rtfDoc);
        this.fontTableParser = new RtfFontTableParser(this.importHeader);
        this.colorTableParser = new RtfColorTableParser(this.importHeader);
        this.handleImportMappings(importMappings);
        this.tokeniser = new RtfTokeniser(this, 1);
        this.tokeniser.tokenise(reader);
    }

    private void handleImportMappings(RtfImportMappings importMappings) {
        Iterator it = importMappings.getFontMappings().keySet().iterator();
        while (it.hasNext()) {
            String fontNr = (String)it.next();
            this.importHeader.importFont(fontNr, (String)importMappings.getFontMappings().get(fontNr));
        }
        it = importMappings.getColorMappings().keySet().iterator();
        while (it.hasNext()) {
            String colorNr = (String)it.next();
            this.importHeader.importColor(colorNr, (Color)importMappings.getColorMappings().get(colorNr));
        }
    }

    public void handleOpenGroup(int groupLevel) {
        if (this.state == 8) {
            this.rtfDoc.add(new RtfDirectContent("{"));
        }
    }

    public void handleCloseGroup(int groupLevel) {
        if (this.state == 8 && groupLevel > 1) {
            this.rtfDoc.add(new RtfDirectContent("}"));
        } else if (this.state == 4 && groupLevel == 2) {
            this.state = 8;
        } else if (this.state == 1) {
            this.fontTableParser.handleCloseGroup(groupLevel);
            if (groupLevel == 2) {
                this.state = 0;
            }
        } else if (this.state == 2) {
            this.state = 0;
        }
    }

    public void handleCtrlCharacter(String ctrlCharacter, int groupLevel) {
        if (this.state == 8) {
            this.rtfDoc.add(new RtfDirectContent(ctrlCharacter));
        }
    }

    public void handleCtrlWord(String ctrlWord, int groupLevel) {
        if (this.state == 8) {
            if (RtfColorTableParser.stringMatches(ctrlWord, "\\f")) {
                ctrlWord = "\\f" + this.importHeader.mapFontNr(ctrlWord.substring(2));
            } else if (RtfColorTableParser.stringMatches(ctrlWord, "\\cf")) {
                ctrlWord = "\\cf" + this.importHeader.mapColorNr(ctrlWord.substring(3));
            } else if (RtfColorTableParser.stringMatches(ctrlWord, "\\cb")) {
                ctrlWord = "\\cb" + this.importHeader.mapColorNr(ctrlWord.substring(3));
            }
            this.rtfDoc.add(new RtfDirectContent(ctrlWord));
        } else if (this.state == 1) {
            this.fontTableParser.handleCtrlWord(ctrlWord, groupLevel);
        } else if (this.state == 2) {
            this.colorTableParser.handleCtrlWord(ctrlWord, groupLevel);
        } else if (this.state == 0) {
            if (ctrlWord.equals("\\info")) {
                this.state = 4;
            } else if (ctrlWord.equals("\\fonttbl")) {
                this.state = 1;
            } else if (ctrlWord.equals("\\colortbl")) {
                this.state = 2;
            }
        }
    }

    public void handleText(String text, int groupLevel) {
        if (this.state == 8) {
            this.rtfDoc.add(new RtfDirectContent(text));
        } else if (this.state == 1) {
            this.fontTableParser.handleText(text, groupLevel);
        } else if (this.state == 2) {
            this.colorTableParser.handleText(text, groupLevel);
        }
    }
}

