/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.rooms;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.rooms.RoomCommand;

public class ExchangeInfoReq
extends RoomCommand {
    private final int exchange;

    protected ExchangeInfoReq(SnacPacket packet) {
        super(3);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.exchange = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
    }

    public ExchangeInfoReq(int exchange) {
        super(3);
        DefensiveTools.checkRange((int)exchange, (String)"exchange", (int)0);
        this.exchange = exchange;
    }

    public final int getExchange() {
        return this.exchange;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.exchange != -1) {
            BinaryTools.writeUShort((OutputStream)out, (int)this.exchange);
        }
    }

    public String toString() {
        return "ExchangeInfoReq for exchange #" + this.exchange;
    }
}

