/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterChainBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIoFilterChainBuilder
implements IoFilterChainBuilder,
Cloneable {
    private List<IoFilterChain.Entry> entries;
    private Map<String, IoFilterChain.Entry> entriesByName;

    public DefaultIoFilterChainBuilder() {
        this.init();
    }

    private void init() {
        this.entries = new ArrayList<IoFilterChain.Entry>();
        this.entriesByName = new HashMap<String, IoFilterChain.Entry>();
    }

    public synchronized IoFilterChain.Entry getEntry(String name) {
        return this.entriesByName.get(name);
    }

    public synchronized IoFilter get(String name) {
        IoFilterChain.Entry e = this.getEntry(name);
        if (e == null) {
            return null;
        }
        return e.getFilter();
    }

    public List<IoFilterChain.Entry> getAll() {
        return new ArrayList<IoFilterChain.Entry>(this.entries);
    }

    public List<IoFilterChain.Entry> getAllReversed() {
        List<IoFilterChain.Entry> result = this.getAll();
        Collections.reverse(result);
        return result;
    }

    public boolean contains(String name) {
        return this.getEntry(name) != null;
    }

    public boolean contains(IoFilter filter) {
        for (IoFilterChain.Entry e : this.entries) {
            if (e.getFilter() != filter) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class<? extends IoFilter> filterType) {
        for (IoFilterChain.Entry e : this.entries) {
            if (!filterType.isAssignableFrom(e.getFilter().getClass())) continue;
            return true;
        }
        return false;
    }

    public synchronized void addFirst(String name, IoFilter filter) {
        this.register(0, new EntryImpl(name, filter));
    }

    public synchronized void addLast(String name, IoFilter filter) {
        this.register(this.entries.size(), new EntryImpl(name, filter));
    }

    public synchronized void addBefore(String baseName, String name, IoFilter filter) {
        this.checkBaseName(baseName);
        ListIterator<IoFilterChain.Entry> i = this.entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry base = i.next();
            if (!base.getName().equals(baseName)) continue;
            this.register(i.previousIndex(), new EntryImpl(name, filter));
            break;
        }
    }

    public synchronized void addAfter(String baseName, String name, IoFilter filter) {
        this.checkBaseName(baseName);
        ArrayList<IoFilterChain.Entry> entries = new ArrayList<IoFilterChain.Entry>(this.entries);
        ListIterator i = entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry base = (IoFilterChain.Entry)i.next();
            if (!base.getName().equals(baseName)) continue;
            this.register(i.nextIndex(), new EntryImpl(name, filter));
            break;
        }
    }

    public synchronized IoFilter remove(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        ListIterator<IoFilterChain.Entry> i = this.entries.listIterator();
        while (i.hasNext()) {
            IoFilterChain.Entry e = i.next();
            if (!e.getName().equals(name)) continue;
            this.deregister(i.previousIndex(), e);
            return e.getFilter();
        }
        throw new IllegalArgumentException("Unknown filter name: " + name);
    }

    public synchronized void clear() throws Exception {
        this.init();
    }

    @Override
    public void buildFilterChain(IoFilterChain chain) throws Exception {
        for (IoFilterChain.Entry e : this.entries) {
            chain.addLast(e.getName(), e.getFilter());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        boolean empty = true;
        for (IoFilterChain.Entry e : this.entries) {
            if (!empty) {
                buf.append(", ");
            } else {
                empty = false;
            }
            buf.append('(');
            buf.append(e.getName());
            buf.append(':');
            buf.append(e.getFilter());
            buf.append(')');
        }
        if (empty) {
            buf.append("empty");
        }
        buf.append(" }");
        return buf.toString();
    }

    public Object clone() {
        DefaultIoFilterChainBuilder ret;
        try {
            ret = (DefaultIoFilterChainBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
        ret.init();
        for (IoFilterChain.Entry e : this.entries) {
            ret.addLast(e.getName(), e.getFilter());
        }
        return ret;
    }

    private void checkBaseName(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("baseName");
        }
        if (!this.entriesByName.containsKey(baseName)) {
            throw new IllegalArgumentException("Unknown filter name: " + baseName);
        }
    }

    private void register(int index, IoFilterChain.Entry e) {
        if (this.entriesByName.containsKey(e.getName())) {
            throw new IllegalArgumentException("Other filter is using the same name: " + e.getName());
        }
        ArrayList<IoFilterChain.Entry> newEntries = new ArrayList<IoFilterChain.Entry>(this.entries);
        newEntries.add(index, e);
        this.entries = newEntries;
        this.entriesByName.put(e.getName(), e);
    }

    private void deregister(int index, IoFilterChain.Entry e) {
        ArrayList<IoFilterChain.Entry> newEntries = new ArrayList<IoFilterChain.Entry>(this.entries);
        newEntries.remove(index);
        this.entries = newEntries;
        this.entriesByName.remove(e.getName());
    }

    private static class EntryImpl
    implements IoFilterChain.Entry {
        private final String name;
        private final IoFilter filter;

        private EntryImpl(String name, IoFilter filter) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public IoFilter getFilter() {
            return this.filter;
        }

        public IoFilter.NextFilter getNextFilter() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "(" + this.getName() + ':' + this.filter + ')';
        }
    }
}

