/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DepthSelector
extends BaseExtendSelector {
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";
    public int min;
    public int max;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{depthselector min: ");
        stringBuffer.append(this.min);
        stringBuffer.append(" max: ");
        stringBuffer.append(this.max);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setMin(int n) {
        this.min = n;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                String string = parameterArray[n].getName();
                if (MIN_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setMin(Integer.parseInt(parameterArray[n].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid minimum value " + parameterArray[n].getValue());
                    }
                } else if (MAX_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setMax(Integer.parseInt(parameterArray[n].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid maximum value " + parameterArray[n].getValue());
                    }
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.min < 0 && this.max < 0) {
            this.setError("You must set at least one of the min or the max levels.");
        }
        if (this.max < this.min && this.max > -1) {
            this.setError("The maximum depth is lower than the minimum.");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        int n = -1;
        String string2 = file.getAbsolutePath();
        String string3 = file2.getAbsolutePath();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.separator);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, File.separator);
        while (stringTokenizer2.hasMoreTokens()) {
            String string4 = stringTokenizer2.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (string5.equals(string4)) continue;
                throw new BuildException("File " + string + " does not appear within " + string2 + "directory");
            }
            if (this.max <= -1 || ++n <= this.max) continue;
            return false;
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new BuildException("File " + string + " is outside of " + string2 + "directory tree");
        }
        return this.min <= -1 || n >= this.min;
    }

    private final /* synthetic */ void this() {
        this.min = -1;
        this.max = -1;
    }

    public DepthSelector() {
        this.this();
    }
}

