/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.taskdefs.condition.ConditionBase;

public class Exit
extends Task {
    private String message;
    private String ifCondition;
    private String unlessCondition;
    private NestedCondition nestedCondition;
    private Integer status;

    public void setMessage(String string) {
        this.message = string;
    }

    public void setIf(String string) {
        this.ifCondition = string;
    }

    public void setUnless(String string) {
        this.unlessCondition = string;
    }

    public void setStatus(int n) {
        this.status = new Integer(n);
    }

    public void execute() throws BuildException {
        boolean bl;
        boolean bl2;
        if (this.nestedConditionPresent()) {
            bl2 = this.testNestedCondition();
        } else {
            bl2 = false;
            if (this.testIfCondition() && this.testUnlessCondition()) {
                bl2 = bl = true;
            }
        }
        if (bl) {
            String string = null;
            if (this.message != null && this.message.trim().length() > 0) {
                string = this.message.trim();
            } else {
                if (this.ifCondition != null && this.ifCondition.length() > 0 && this.getProject().getProperty(this.ifCondition) != null) {
                    string = "if=" + this.ifCondition;
                }
                if (this.unlessCondition != null && this.unlessCondition.length() > 0 && this.getProject().getProperty(this.unlessCondition) == null) {
                    string = string == null ? "" : string + " and ";
                    string = string + "unless=" + this.unlessCondition;
                }
                if (this.nestedConditionPresent()) {
                    string = "condition satisfied";
                } else if (string == null) {
                    string = "No message";
                }
            }
            throw this.status == null ? new BuildException(string) : new ExitStatusException(string, this.status);
        }
    }

    public void addText(String string) {
        if (this.message == null) {
            this.message = "";
        }
        this.message = this.message + this.getProject().replaceProperties(string);
    }

    public ConditionBase createCondition() {
        if (this.nestedCondition != null) {
            throw new BuildException("Only one nested condition is allowed.");
        }
        this.nestedCondition = new NestedCondition();
        return this.nestedCondition;
    }

    private final boolean testIfCondition() {
        if (this.ifCondition == null || "".equals(this.ifCondition)) {
            return true;
        }
        boolean bl = false;
        if (this.getProject().getProperty(this.ifCondition) != null) {
            bl = true;
        }
        return bl;
    }

    private final boolean testUnlessCondition() {
        if (this.unlessCondition == null || "".equals(this.unlessCondition)) {
            return true;
        }
        boolean bl = false;
        if (this.getProject().getProperty(this.unlessCondition) == null) {
            bl = true;
        }
        return bl;
    }

    private final boolean testNestedCondition() {
        boolean bl = this.nestedConditionPresent();
        if (bl && this.ifCondition != null || this.unlessCondition != null) {
            throw new BuildException("Nested conditions not permitted in conjunction with if/unless attributes");
        }
        boolean bl2 = false;
        if (bl && this.nestedCondition.eval()) {
            bl2 = true;
        }
        return bl2;
    }

    private final boolean nestedConditionPresent() {
        boolean bl = false;
        if (this.nestedCondition != null) {
            bl = true;
        }
        return bl;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NestedCondition
    extends ConditionBase
    implements Condition {
        public boolean eval() {
            if (this.countConditions() != 1) {
                throw new BuildException("A single nested condition is required.");
            }
            return ((Condition)this.getConditions().nextElement()).eval();
        }

        private NestedCondition() {
        }
    }
}

